/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.AssociationRule;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Item;
import org.dmg.pmml.Itemset;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.DecimalAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "localTransformations", "items", "itemsets", "associationRules", "modelVerification"})
@XmlRootElement(name="AssociationModel", namespace="http://www.dmg.org/PMML-4_2")
public class AssociationModel
extends Model
implements HasExtensions {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunctionType functionName;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="numberOfTransactions", required=true)
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer numberOfTransactions;
    @XmlAttribute(name="maxNumberOfItemsPerTA")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer maxNumberOfItemsPerTA;
    @XmlAttribute(name="avgNumberOfItemsPerTA")
    private Double avgNumberOfItemsPerTA;
    @XmlAttribute(name="minimumSupport", required=true)
    @XmlJavaTypeAdapter(value=DecimalAdapter.class)
    private Double minimumSupport;
    @XmlAttribute(name="minimumConfidence", required=true)
    @XmlJavaTypeAdapter(value=DecimalAdapter.class)
    private Double minimumConfidence;
    @XmlAttribute(name="lengthLimit")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer lengthLimit;
    @XmlAttribute(name="numberOfItems", required=true)
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer numberOfItems;
    @XmlAttribute(name="numberOfItemsets", required=true)
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer numberOfItemsets;
    @XmlAttribute(name="numberOfRules", required=true)
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer numberOfRules;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_2")
    @Added(value=Version.PMML_4_0)
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name="Item", namespace="http://www.dmg.org/PMML-4_2")
    private List<Item> items;
    @XmlElement(name="Itemset", namespace="http://www.dmg.org/PMML-4_2")
    private List<Itemset> itemsets;
    @XmlElement(name="AssociationRule", namespace="http://www.dmg.org/PMML-4_2")
    private List<AssociationRule> associationRules;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_2")
    @Added(value=Version.PMML_4_1)
    private ModelVerification modelVerification;

    public AssociationModel() {
    }

    public AssociationModel(MiningFunctionType functionName, Integer numberOfTransactions, Double minimumSupport, Double minimumConfidence, Integer numberOfItems, Integer numberOfItemsets, Integer numberOfRules, MiningSchema miningSchema) {
        this.functionName = functionName;
        this.numberOfTransactions = numberOfTransactions;
        this.minimumSupport = minimumSupport;
        this.minimumConfidence = minimumConfidence;
        this.numberOfItems = numberOfItems;
        this.numberOfItemsets = numberOfItemsets;
        this.numberOfRules = numberOfRules;
        this.miningSchema = miningSchema;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public AssociationModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunctionType getFunctionName() {
        return this.functionName;
    }

    @Override
    public AssociationModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public AssociationModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer getNumberOfTransactions() {
        return this.numberOfTransactions;
    }

    public AssociationModel setNumberOfTransactions(Integer numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        return this;
    }

    public Integer getMaxNumberOfItemsPerTA() {
        return this.maxNumberOfItemsPerTA;
    }

    public AssociationModel setMaxNumberOfItemsPerTA(Integer maxNumberOfItemsPerTA) {
        this.maxNumberOfItemsPerTA = maxNumberOfItemsPerTA;
        return this;
    }

    public Double getAvgNumberOfItemsPerTA() {
        return this.avgNumberOfItemsPerTA;
    }

    public AssociationModel setAvgNumberOfItemsPerTA(Double avgNumberOfItemsPerTA) {
        this.avgNumberOfItemsPerTA = avgNumberOfItemsPerTA;
        return this;
    }

    public Double getMinimumSupport() {
        return this.minimumSupport;
    }

    public AssociationModel setMinimumSupport(Double minimumSupport) {
        this.minimumSupport = minimumSupport;
        return this;
    }

    public Double getMinimumConfidence() {
        return this.minimumConfidence;
    }

    public AssociationModel setMinimumConfidence(Double minimumConfidence) {
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    public Integer getLengthLimit() {
        return this.lengthLimit;
    }

    public AssociationModel setLengthLimit(Integer lengthLimit) {
        this.lengthLimit = lengthLimit;
        return this;
    }

    public Integer getNumberOfItems() {
        return this.numberOfItems;
    }

    public AssociationModel setNumberOfItems(Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    public Integer getNumberOfItemsets() {
        return this.numberOfItemsets;
    }

    public AssociationModel setNumberOfItemsets(Integer numberOfItemsets) {
        this.numberOfItemsets = numberOfItemsets;
        return this;
    }

    public Integer getNumberOfRules() {
        return this.numberOfRules;
    }

    public AssociationModel setNumberOfRules(Integer numberOfRules) {
        this.numberOfRules = numberOfRules;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return true;
        }
        return this.scorable;
    }

    @Override
    public AssociationModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public AssociationModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public AssociationModel setOutput(Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public AssociationModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public AssociationModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public List<Item> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        return this.items;
    }

    public List<Itemset> getItemsets() {
        if (this.itemsets == null) {
            this.itemsets = new ArrayList<Itemset>();
        }
        return this.itemsets;
    }

    public List<AssociationRule> getAssociationRules() {
        if (this.associationRules == null) {
            this.associationRules = new ArrayList<AssociationRule>();
        }
        return this.associationRules;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public AssociationModel setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public AssociationModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasItems() {
        return this.items != null && this.items.size() > 0;
    }

    public AssociationModel addItems(Item ... items) {
        this.getItems().addAll(Arrays.asList(items));
        return this;
    }

    public boolean hasItemsets() {
        return this.itemsets != null && this.itemsets.size() > 0;
    }

    public AssociationModel addItemsets(Itemset ... itemsets) {
        this.getItemsets().addAll(Arrays.asList(itemsets));
        return this;
    }

    public boolean hasAssociationRules() {
        return this.associationRules != null && this.associationRules.size() > 0;
    }

    public AssociationModel addAssociationRules(AssociationRule ... associationRules) {
        this.getAssociationRules().addAll(Arrays.asList(associationRules));
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AssociationModel setModelExplanation(ModelExplanation modelExplanation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Targets getTargets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AssociationModel setTargets(Targets targets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        MiningSchema miningSchema = this.getMiningSchema();
        if (status == VisitorAction.CONTINUE && miningSchema != null) {
            status = miningSchema.accept(visitor);
        }
        Output output = this.getOutput();
        if (status == VisitorAction.CONTINUE && output != null) {
            status = output.accept(visitor);
        }
        ModelStats modelStats = this.getModelStats();
        if (status == VisitorAction.CONTINUE && modelStats != null) {
            status = modelStats.accept(visitor);
        }
        LocalTransformations localTransformations = this.getLocalTransformations();
        if (status == VisitorAction.CONTINUE && localTransformations != null) {
            status = localTransformations.accept(visitor);
        }
        if (status == VisitorAction.CONTINUE && this.hasItems()) {
            status = PMMLObject.traverse(visitor, this.getItems());
        }
        if (status == VisitorAction.CONTINUE && this.hasItemsets()) {
            status = PMMLObject.traverse(visitor, this.getItemsets());
        }
        if (status == VisitorAction.CONTINUE && this.hasAssociationRules()) {
            status = PMMLObject.traverse(visitor, this.getAssociationRules());
        }
        ModelVerification modelVerification = this.getModelVerification();
        if (status == VisitorAction.CONTINUE && modelVerification != null) {
            status = modelVerification.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

