/*
 * Decompiled with CFR 0.152.
 */
package org.jpastebin.pastebin.account;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.jpastebin.utils.xml.XMLUtils;
import org.w3c.dom.Element;

public class PastebinAccountDetails {
    private String username;
    private String format;
    private String expiration;
    private String avatarURL;
    private String website;
    private String email;
    private String location;
    private int userPrivate;
    private int accountType;

    public PastebinAccountDetails(Element userElement) {
        this.username = XMLUtils.getText(userElement, "user_name");
        this.format = XMLUtils.getText(userElement, "user_format_short");
        this.expiration = XMLUtils.getText(userElement, "user_expiration");
        this.avatarURL = XMLUtils.getText(userElement, "user_avatar_url");
        this.userPrivate = Integer.parseInt(XMLUtils.getText(userElement, "user_private"));
        this.website = XMLUtils.getText(userElement, "user_website");
        this.email = XMLUtils.getText(userElement, "user_email");
        this.location = XMLUtils.getText(userElement, "user_location");
        this.accountType = Integer.parseInt(XMLUtils.getText(userElement, "user_account_type"));
    }

    public String getUsername() {
        return this.username;
    }

    public String getFormat() {
        return this.format;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public URL getAvatarURL() throws MalformedURLException {
        return new URL(this.avatarURL);
    }

    public int getPrivate() {
        return this.userPrivate;
    }

    public URL getWebsite() throws MalformedURLException {
        if (this.website.isEmpty()) {
            return null;
        }
        return new URL(this.website);
    }

    public String getEmail() {
        return this.email;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isPro() {
        return this.accountType == 1;
    }

    public BufferedImage getAvatar() throws IOException {
        return ImageIO.read(this.getAvatarURL());
    }
}

