/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.ast.declaration;

import java.util.List;
import org.jparsec.examples.common.Strings;
import org.jparsec.examples.common.ValueObject;
import org.jparsec.examples.java.ast.declaration.Member;
import org.jparsec.examples.java.ast.statement.BlockStatement;
import org.jparsec.examples.java.ast.statement.Modifier;
import org.jparsec.examples.java.ast.statement.ParameterDef;
import org.jparsec.examples.java.ast.type.TypeLiteral;

public final class ConstructorDef
extends ValueObject
implements Member {
    public final List<Modifier> modifiers;
    public final String name;
    public final List<ParameterDef> parameters;
    public final List<TypeLiteral> exceptions;
    public final BlockStatement body;

    public ConstructorDef(List<Modifier> modifiers, String name, List<ParameterDef> parameters, List<TypeLiteral> exceptions, BlockStatement body) {
        this.modifiers = modifiers;
        this.name = name;
        this.parameters = parameters;
        this.exceptions = exceptions;
        this.body = body;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Modifier modifier : this.modifiers) {
            builder.append(modifier).append(' ');
        }
        builder.append(this.name).append('(');
        Strings.join(builder, ", ", this.parameters);
        builder.append(')');
        if (this.exceptions != null) {
            builder.append(" throws ");
            Strings.join(builder, ", ", this.exceptions);
        }
        builder.append(' ').append(this.body);
        return builder.toString();
    }
}

