/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.ast.statement;

import java.util.List;
import org.jparsec.examples.common.Strings;
import org.jparsec.examples.common.ValueObject;
import org.jparsec.examples.java.ast.expression.Expression;
import org.jparsec.examples.java.ast.statement.Modifier;
import org.jparsec.examples.java.ast.statement.Statement;
import org.jparsec.examples.java.ast.type.TypeLiteral;

public final class VarStatement
extends ValueObject
implements Statement {
    public final List<Modifier> modifiers;
    public final TypeLiteral type;
    public final List<Var> vars;

    public VarStatement(List<Modifier> modifiers, TypeLiteral type, List<Var> vars) {
        this.modifiers = modifiers;
        this.type = type;
        this.vars = vars;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Modifier modifier : this.modifiers) {
            builder.append(modifier).append(' ');
        }
        builder.append(this.type).append(" ");
        Strings.join(builder, ", ", this.vars);
        builder.append(";");
        return builder.toString();
    }

    public static final class Var
    extends ValueObject {
        public final String name;
        public final Expression value;

        public Var(String name, Expression value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String toString() {
            return this.name + (this.value == null ? "" : " = " + this.value);
        }
    }
}

