/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public final class IoUtils {
    public static String read(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            String string = IoUtils.read(new InputStreamReader(in, Charset.forName("UTF-8")));
            return string;
        }
    }

    public static String read(Readable readable) throws IOException {
        StringBuilder builder = new StringBuilder();
        IoUtils.copy(readable, builder);
        return builder.toString();
    }

    public static void copy(Readable from, Appendable to) throws IOException {
        int r;
        CharBuffer buf = CharBuffer.allocate(2048);
        while ((r = from.read(buf)) != -1) {
            buf.flip();
            to.append(buf, 0, r);
        }
    }
}

