/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.sql.parser;

import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import org.jparsec.OperatorTable;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.examples.sql.ast.BetweenExpression;
import org.jparsec.examples.sql.ast.BinaryExpression;
import org.jparsec.examples.sql.ast.BinaryRelationalExpression;
import org.jparsec.examples.sql.ast.Expression;
import org.jparsec.examples.sql.ast.FullCaseExpression;
import org.jparsec.examples.sql.ast.FunctionExpression;
import org.jparsec.examples.sql.ast.LikeExpression;
import org.jparsec.examples.sql.ast.NullExpression;
import org.jparsec.examples.sql.ast.NumberExpression;
import org.jparsec.examples.sql.ast.Op;
import org.jparsec.examples.sql.ast.QualifiedName;
import org.jparsec.examples.sql.ast.QualifiedNameExpression;
import org.jparsec.examples.sql.ast.Relation;
import org.jparsec.examples.sql.ast.SimpleCaseExpression;
import org.jparsec.examples.sql.ast.StringExpression;
import org.jparsec.examples.sql.ast.TupleExpression;
import org.jparsec.examples.sql.ast.UnaryExpression;
import org.jparsec.examples.sql.ast.UnaryRelationalExpression;
import org.jparsec.examples.sql.ast.WildcardExpression;
import org.jparsec.examples.sql.parser.TerminalParser;
import org.jparsec.functors.Pair;

public final class ExpressionParser {
    static final Parser<Expression> NULL = TerminalParser.term("null").retn((Object)NullExpression.instance);
    static final Parser<Expression> NUMBER = TerminalParser.NUMBER.map(NumberExpression::new);
    static final Parser<Expression> QUALIFIED_NAME = TerminalParser.QUALIFIED_NAME.map(QualifiedNameExpression::new);
    static final Parser<Expression> QUALIFIED_WILDCARD = TerminalParser.QUALIFIED_NAME.followedBy(TerminalParser.phrase(". *")).map(WildcardExpression::new);
    static final Parser<Expression> WILDCARD = TerminalParser.term("*").retn((Object)new WildcardExpression(QualifiedName.of(new String[0]))).or(QUALIFIED_WILDCARD);
    static final Parser<Expression> STRING = TerminalParser.STRING.map(StringExpression::new);

    static Parser<Expression> functionCall(Parser<Expression> param) {
        return Parsers.sequence(TerminalParser.QUALIFIED_NAME, ExpressionParser.paren(param.sepBy(TerminalParser.term(","))), FunctionExpression::new);
    }

    static Parser<Expression> tuple(Parser<Expression> expr) {
        return ExpressionParser.paren(expr.sepBy(TerminalParser.term(","))).map(TupleExpression::new);
    }

    static Parser<Expression> simpleCase(Parser<Expression> expr) {
        return Parsers.sequence((Parser)TerminalParser.term("case").next(expr), ExpressionParser.whenThens(expr, expr), (Parser)TerminalParser.term("else").next(expr).optional().followedBy(TerminalParser.term("end")), SimpleCaseExpression::new);
    }

    static Parser<Expression> fullCase(Parser<Expression> cond, Parser<Expression> expr) {
        return Parsers.sequence((Parser)TerminalParser.term("case").next(ExpressionParser.whenThens(cond, expr)), (Parser)TerminalParser.term("else").next(expr).optional().followedBy(TerminalParser.term("end")), FullCaseExpression::new);
    }

    private static Parser<List<Pair<Expression, Expression>>> whenThens(Parser<Expression> cond, Parser<Expression> expr) {
        return Parsers.pair((Parser)TerminalParser.term("when").next(cond), (Parser)TerminalParser.term("then").next(expr)).many1();
    }

    static <T> Parser<T> paren(Parser<T> parser) {
        return parser.between(TerminalParser.term("("), TerminalParser.term(")"));
    }

    static Parser<Expression> arithmetic(Parser<Expression> atom) {
        Parser.Reference reference = Parser.newReference();
        Parser operand = Parsers.or(ExpressionParser.paren(reference.lazy()), ExpressionParser.functionCall((Parser<Expression>)reference.lazy()), atom);
        Parser parser = new OperatorTable().infixl(ExpressionParser.binary("+", Op.PLUS), 10).infixl(ExpressionParser.binary("-", Op.MINUS), 10).infixl(ExpressionParser.binary("*", Op.MUL), 20).infixl(ExpressionParser.binary("/", Op.DIV), 20).infixl(ExpressionParser.binary("%", Op.MOD), 20).prefix(ExpressionParser.unary("-", Op.NEG), 50).build(operand);
        reference.set((Object)parser);
        return parser;
    }

    static Parser<Expression> expression(Parser<Expression> cond) {
        Parser.Reference reference = Parser.newReference();
        Parser lazyExpr = reference.lazy();
        Parser atom = Parsers.or(NUMBER, WILDCARD, QUALIFIED_NAME, ExpressionParser.simpleCase((Parser<Expression>)lazyExpr), ExpressionParser.fullCase(cond, (Parser<Expression>)lazyExpr));
        Parser expression = ExpressionParser.arithmetic((Parser<Expression>)atom).label("expression");
        reference.set((Object)expression);
        return expression;
    }

    static Parser<Expression> compare(Parser<Expression> expr) {
        return Parsers.or(ExpressionParser.compare(expr, ">", Op.GT), ExpressionParser.compare(expr, ">=", Op.GE), ExpressionParser.compare(expr, "<", Op.LT), ExpressionParser.compare(expr, "<=", Op.LE), ExpressionParser.compare(expr, "=", Op.EQ), ExpressionParser.compare(expr, "<>", Op.NE), ExpressionParser.nullCheck(expr), ExpressionParser.like(expr), ExpressionParser.between(expr));
    }

    static Parser<Expression> like(Parser<Expression> expr) {
        return Parsers.sequence(expr, (Parser)Parsers.or((Parser)TerminalParser.term("like").retn((Object)true), (Parser)TerminalParser.phrase("not like").retn((Object)false)), expr, (Parser)TerminalParser.term("escape").next(expr).optional(), LikeExpression::new);
    }

    static Parser<Expression> nullCheck(Parser<Expression> expr) {
        return Parsers.sequence(expr, (Parser)TerminalParser.phrase("is not").retn((Object)Op.NOT).or(TerminalParser.phrase("is").retn((Object)Op.IS)), NULL, BinaryExpression::new);
    }

    static Parser<Expression> logical(Parser<Expression> expr) {
        Parser.Reference ref = Parser.newReference();
        Parser parser = new OperatorTable().prefix(ExpressionParser.unary("not", Op.NOT), 30).infixl(ExpressionParser.binary("and", Op.AND), 20).infixl(ExpressionParser.binary("or", Op.OR), 10).build(ExpressionParser.paren(ref.lazy()).or(expr)).label("logical expression");
        ref.set((Object)parser);
        return parser;
    }

    static Parser<Expression> between(Parser<Expression> expr) {
        return Parsers.sequence(expr, (Parser)Parsers.or((Parser)TerminalParser.term("between").retn((Object)true), (Parser)TerminalParser.phrase("not between").retn((Object)false)), expr, (Parser)TerminalParser.term("and").next(expr), BetweenExpression::new);
    }

    static Parser<Expression> exists(Parser<Relation> relation) {
        return TerminalParser.term("exists").next(relation).map(e -> new UnaryRelationalExpression((Relation)e, Op.EXISTS));
    }

    static Parser<Expression> notExists(Parser<Relation> relation) {
        return TerminalParser.phrase("not exists").next(relation).map(e -> new UnaryRelationalExpression((Relation)e, Op.NOT_EXISTS));
    }

    static Parser<Expression> inRelation(Parser<Expression> expr, Parser<Relation> relation) {
        return Parsers.sequence(expr, (Parser)Parsers.between(TerminalParser.phrase("in ("), relation, TerminalParser.term(")")), (e, r) -> new BinaryRelationalExpression((Expression)e, Op.IN, (Relation)r));
    }

    static Parser<Expression> notInRelation(Parser<Expression> expr, Parser<Relation> relation) {
        return Parsers.sequence(expr, (Parser)Parsers.between(TerminalParser.phrase("not in ("), relation, TerminalParser.term(")")), (e, r) -> new BinaryRelationalExpression((Expression)e, Op.NOT_IN, (Relation)r));
    }

    static Parser<Expression> in(Parser<Expression> expr) {
        return Parsers.sequence(expr, (Parser)TerminalParser.term("in").next(ExpressionParser.tuple(expr)), (e, t) -> new BinaryExpression((Expression)e, Op.IN, (Expression)t));
    }

    static Parser<Expression> notIn(Parser<Expression> expr) {
        return Parsers.sequence(expr, (Parser)TerminalParser.phrase("not in").next(ExpressionParser.tuple(expr)), (e, t) -> new BinaryExpression((Expression)e, Op.NOT_IN, (Expression)t));
    }

    static Parser<Expression> condition(Parser<Expression> expr, Parser<Relation> rel) {
        Parser atom = Parsers.or(ExpressionParser.compare(expr), ExpressionParser.in(expr), ExpressionParser.notIn(expr), ExpressionParser.exists(rel), ExpressionParser.notExists(rel), ExpressionParser.inRelation(expr, rel), ExpressionParser.notInRelation(expr, rel));
        return ExpressionParser.logical((Parser<Expression>)atom);
    }

    private static Parser<Expression> compare(Parser<Expression> operand, String name, Op op) {
        return Parsers.sequence(operand, (Parser)TerminalParser.term(name).retn((Object)op), operand, BinaryExpression::new);
    }

    private static Parser<BinaryOperator<Expression>> binary(String name, Op op) {
        return TerminalParser.term(name).retn((l, r) -> new BinaryExpression((Expression)l, op, (Expression)r));
    }

    private static Parser<UnaryOperator<Expression>> unary(String name, Op op) {
        return TerminalParser.term(name).retn(e -> new UnaryExpression(op, (Expression)e));
    }
}

