/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.sql.parser;

import java.util.List;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.examples.sql.ast.AliasedRelation;
import org.codehaus.jparsec.examples.sql.ast.CrossJoinRelation;
import org.codehaus.jparsec.examples.sql.ast.Expression;
import org.codehaus.jparsec.examples.sql.ast.GroupBy;
import org.codehaus.jparsec.examples.sql.ast.JoinRelation;
import org.codehaus.jparsec.examples.sql.ast.JoinType;
import org.codehaus.jparsec.examples.sql.ast.OrderBy;
import org.codehaus.jparsec.examples.sql.ast.Projection;
import org.codehaus.jparsec.examples.sql.ast.Relation;
import org.codehaus.jparsec.examples.sql.ast.Select;
import org.codehaus.jparsec.examples.sql.ast.TableRelation;
import org.codehaus.jparsec.examples.sql.ast.UnionRelation;
import org.codehaus.jparsec.examples.sql.parser.ExpressionParser;
import org.codehaus.jparsec.examples.sql.parser.TerminalParser;
import org.codehaus.jparsec.functors.Unary;
import org.codehaus.jparsec.misc.Mapper;

public final class RelationParser {
    static final Parser<String> ALIAS = TerminalParser.term("as").optional().next(TerminalParser.NAME);
    static final Parser<JoinType> FULL_JOIN = RelationParser.joinType(JoinType.FULL, "full join", "full outer join");
    static final Parser<JoinType> RIGHT_JOIN = RelationParser.joinType(JoinType.RIGHT, "right join", "right outer join");
    static final Parser<JoinType> LEFT_JOIN = RelationParser.joinType(JoinType.LEFT, "left join", "left outer join");
    static final Parser<JoinType> INNER_JOIN = RelationParser.joinType(JoinType.INNER, "join", "inner join");
    static final Parser<Relation> TABLE = RelationParser.curry(TableRelation.class, new Object[0]).sequence(new Parser[]{TerminalParser.QUALIFIED_NAME});
    static final Parser<Boolean> SELECT_CLAUSE = TerminalParser.term("select").next(TerminalParser.term("distinct").succeeds());

    static final Parser<Projection> projection(Parser<Expression> expr) {
        return Mapper.curry(Projection.class, (Object[])new Object[0]).sequence(new Parser[]{expr, ALIAS.optional()});
    }

    static final Parser<Relation> alias(Parser<Relation> rel) {
        return RelationParser.curry(AliasedRelation.class, new Object[0]).sequence(new Parser[]{rel, ALIAS});
    }

    static final Parser<Relation> aliasable(Parser<Relation> rel) {
        return RelationParser.alias(rel).or(rel);
    }

    static final Parser<Boolean> selectClause() {
        return TerminalParser.term("select").next(TerminalParser.term("distinct").succeeds());
    }

    static Parser<List<Relation>> fromClause(Parser<Relation> rel) {
        return TerminalParser.term("from").next(RelationParser.aliasable(rel).sepBy1(TerminalParser.term(",")));
    }

    static Parser<Expression> whereClause(Parser<Expression> cond) {
        return TerminalParser.term("where").next(cond);
    }

    static Parser<GroupBy> groupByClause(Parser<Expression> expr, Parser<Expression> cond) {
        return Mapper.curry(GroupBy.class, (Object[])new Object[0]).sequence(new Parser[]{TerminalParser.phrase("group by").next(RelationParser.list(expr)), TerminalParser.phrase("having").next(cond).optional()});
    }

    static Parser<Expression> havingClause(Parser<Expression> cond) {
        return TerminalParser.term("having").next(cond);
    }

    static Parser<OrderBy.Item> orderByItem(Parser<Expression> expr) {
        return Mapper.curry(OrderBy.Item.class, (Object[])new Object[0]).sequence(new Parser[]{expr, Parsers.or((Parser)TerminalParser.term("asc").retn((Object)true), (Parser)TerminalParser.term("desc").retn((Object)false)).optional((Object)true)});
    }

    static Parser<OrderBy> orderByClause(Parser<Expression> expr) {
        return Mapper.curry(OrderBy.class, (Object[])new Object[0]).sequence(new Parser[]{TerminalParser.phrase("order by").next(RelationParser.list(RelationParser.orderByItem(expr)))});
    }

    static Parser<Relation> join(Parser<Relation> rel, Parser<Expression> cond) {
        Parser.Reference ref = Parser.newReference();
        Parser lazy = ref.lazy();
        Parser<Relation> atom = RelationParser.aliasable((Parser<Relation>)ExpressionParser.paren(lazy).or(rel));
        Parser parser = atom.postfix(Parsers.or(RelationParser.joinOn(INNER_JOIN, (Parser<Relation>)lazy, cond), RelationParser.joinOn(LEFT_JOIN, (Parser<Relation>)lazy, cond), RelationParser.joinOn(RIGHT_JOIN, (Parser<Relation>)lazy, cond), RelationParser.joinOn(FULL_JOIN, (Parser<Relation>)lazy, cond), (Parser)RelationParser.curry(CrossJoinRelation.class, new Object[0]).postfix(new Parser[]{TerminalParser.phrase("cross join"), atom})));
        ref.set((Object)parser);
        return parser;
    }

    static Parser<Relation> select(Parser<Expression> expr, Parser<Expression> cond, Parser<Relation> rel) {
        return RelationParser.curry(Select.class, new Object[0]).sequence(new Parser[]{SELECT_CLAUSE, RelationParser.list(RelationParser.projection(expr)), RelationParser.fromClause(RelationParser.join(rel, cond)), RelationParser.whereClause(cond).optional(), RelationParser.groupByClause(expr, cond).optional(), RelationParser.orderByClause(expr).optional()});
    }

    static Parser<Relation> union(Parser<Relation> rel) {
        Parser.Reference ref = Parser.newReference();
        Parser parser = ExpressionParser.paren(ref.lazy()).or(rel).infixl(RelationParser.curry(UnionRelation.class, new Object[0]).infix(new Parser[]{TerminalParser.term("union"), TerminalParser.term("all").succeeds()})).label("relation");
        ref.set((Object)parser);
        return parser;
    }

    static Parser<Relation> query(Parser<Expression> expr, Parser<Expression> cond, Parser<Relation> rel) {
        return RelationParser.union(RelationParser.select(expr, cond, rel));
    }

    public static Parser<Relation> query() {
        Parser.Reference relationRef = Parser.newReference();
        Parser subQuery = ExpressionParser.paren(relationRef.lazy());
        Parser.Reference conditionRef = Parser.newReference();
        Parser<Expression> expr = ExpressionParser.expression((Parser<Expression>)conditionRef.lazy());
        Parser<Expression> cond = ExpressionParser.condition(expr, subQuery);
        Parser<Relation> relation = RelationParser.query(expr, cond, (Parser<Relation>)subQuery.or(TABLE));
        conditionRef.set(cond);
        relationRef.set(relation);
        return relation;
    }

    private static Parser<JoinType> joinType(JoinType joinType, String phrase1, String phrase2) {
        return Parsers.or(TerminalParser.phrase(phrase1), TerminalParser.phrase(phrase2)).retn((Object)joinType);
    }

    private static Parser<Unary<Relation>> joinOn(Parser<JoinType> joinType, Parser<Relation> right, Parser<Expression> cond) {
        return RelationParser.curry(JoinRelation.class, new Object[0]).postfix(new Parser[]{joinType, right, TerminalParser.term("on"), cond});
    }

    private static <T> Parser<List<T>> list(Parser<T> p) {
        return p.sepBy1(TerminalParser.term(","));
    }

    private static Mapper<Relation> curry(Class<? extends Relation> clazz, Object ... args) {
        return Mapper.curry(clazz, (Object[])args);
    }
}

