/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.java.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Terminals;
import org.codehaus.jparsec.examples.java.ast.declaration.AnnotationDef;
import org.codehaus.jparsec.examples.java.ast.declaration.ClassDef;
import org.codehaus.jparsec.examples.java.ast.declaration.ClassInitializerDef;
import org.codehaus.jparsec.examples.java.ast.declaration.ConstructorDef;
import org.codehaus.jparsec.examples.java.ast.declaration.Declaration;
import org.codehaus.jparsec.examples.java.ast.declaration.DefBody;
import org.codehaus.jparsec.examples.java.ast.declaration.EnumDef;
import org.codehaus.jparsec.examples.java.ast.declaration.FieldDef;
import org.codehaus.jparsec.examples.java.ast.declaration.Import;
import org.codehaus.jparsec.examples.java.ast.declaration.InterfaceDef;
import org.codehaus.jparsec.examples.java.ast.declaration.Member;
import org.codehaus.jparsec.examples.java.ast.declaration.MethodDef;
import org.codehaus.jparsec.examples.java.ast.declaration.NestedDef;
import org.codehaus.jparsec.examples.java.ast.declaration.Program;
import org.codehaus.jparsec.examples.java.ast.declaration.QualifiedName;
import org.codehaus.jparsec.examples.java.ast.declaration.TypeParameterDef;
import org.codehaus.jparsec.examples.java.ast.expression.Expression;
import org.codehaus.jparsec.examples.java.ast.statement.Modifier;
import org.codehaus.jparsec.examples.java.ast.statement.Statement;
import org.codehaus.jparsec.examples.java.parser.ExpressionParser;
import org.codehaus.jparsec.examples.java.parser.StatementParser;
import org.codehaus.jparsec.examples.java.parser.TerminalParser;
import org.codehaus.jparsec.examples.java.parser.TypeLiteralParser;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.misc.Mapper;

public final class DeclarationParser {
    static final Parser<TypeParameterDef> TYPE_PARAMETER = Mapper.curry(TypeParameterDef.class, (Object[])new Object[0]).sequence(new Parser[]{Terminals.Identifier.PARSER, TerminalParser.term("extends").next(TypeLiteralParser.TYPE_LITERAL).optional()});
    static final Parser<List<TypeParameterDef>> TYPE_PARAMETERS = Parsers.between(TerminalParser.term("<"), (Parser)TYPE_PARAMETER.sepBy1(TerminalParser.term(",")), TerminalParser.term(">"));
    static final Parser<QualifiedName> QUALIFIED_NAME = Mapper.curry(QualifiedName.class, (Object[])new Object[0]).sequence(new Parser[]{Terminals.Identifier.PARSER.sepBy1(TerminalParser.term("."))});
    static final Parser<Import> IMPORT = Mapper.curry(Import.class, (Object[])new Object[0]).sequence(new Parser[]{TerminalParser.term("import"), TerminalParser.term("static").succeeds(), QUALIFIED_NAME, TerminalParser.phrase(". *").succeeds(), TerminalParser.term(";")});
    static final Parser<QualifiedName> PACKAGE = Parsers.between(TerminalParser.term("package"), QUALIFIED_NAME, TerminalParser.term(";"));

    static Parser<DefBody> body(Parser<Member> member) {
        Parser empty = TerminalParser.term(";").retn(null);
        return Mapper.curry(DefBody.class, (Object[])new Object[0]).sequence(new Parser[]{TerminalParser.term("{"), empty.or(member).many().map((Map)new Map<List<Member>, List<Member>>(){

            public List<Member> map(List<Member> from) {
                DeclarationParser.removeNulls(from);
                return from;
            }
        }), TerminalParser.term("}")});
    }

    static void removeNulls(List<?> list) {
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
    }

    static Parser<Member> fieldDef(Parser<Expression> initializer) {
        return Mapper.curry(FieldDef.class, (Object[])new Object[0]).sequence(new Parser[]{StatementParser.modifier(initializer).many(), TypeLiteralParser.TYPE_LITERAL, Terminals.Identifier.PARSER, TerminalParser.term("=").next(ExpressionParser.arrayInitializerOrRegularExpression(initializer)).optional(), TerminalParser.term(";")});
    }

    static Parser<Member> constructorDef(Parser<Modifier> mod, Parser<Statement> stmt) {
        return Mapper.curry(ConstructorDef.class, (Object[])new Object[0]).sequence(new Parser[]{mod.many(), Terminals.Identifier.PARSER, TerminalParser.term("("), StatementParser.parameter(mod).sepBy(TerminalParser.term(",")), TerminalParser.term(")"), TerminalParser.term("throws").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL.sepBy1(TerminalParser.term(","))).optional(), StatementParser.blockStatement(stmt)});
    }

    static Parser<Member> methodDef(Parser<Modifier> mod, Parser<Expression> defaultValue, Parser<Statement> stmt) {
        return Mapper.curry(MethodDef.class, (Object[])new Object[0]).sequence(new Parser[]{mod.many(), TYPE_PARAMETERS.optional(), TypeLiteralParser.TYPE_LITERAL, Terminals.Identifier.PARSER, TerminalParser.term("("), StatementParser.parameter(mod).sepBy(TerminalParser.term(",")), TerminalParser.term(")"), TerminalParser.term("throws").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL.sepBy1(TerminalParser.term(","))).optional(), TerminalParser.term("default").next(ExpressionParser.arrayInitializerOrRegularExpression(defaultValue)).optional(), Parsers.or(StatementParser.blockStatement(stmt), (Parser)TerminalParser.term(";").retn(null))});
    }

    static Parser<Member> initializerDef(Parser<Statement> stmt) {
        return Mapper.curry(ClassInitializerDef.class, (Object[])new Object[0]).sequence(new Parser[]{TerminalParser.term("static").succeeds(), StatementParser.blockStatement(stmt)});
    }

    static Parser<Member> nestedDef(Parser<Declaration> dec) {
        return Mapper.curry(NestedDef.class, (Object[])new Object[0]).sequence(new Parser[]{dec});
    }

    static Parser<Declaration> classDef(Parser<Modifier> mod, Parser<Member> member) {
        return DeclarationParser.curry(ClassDef.class, new Object[0]).sequence(new Parser[]{mod.many(), TerminalParser.term("class"), Terminals.Identifier.PARSER, TYPE_PARAMETERS.optional(), TerminalParser.term("extends").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL).optional(), TerminalParser.term("implements").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL.sepBy1(TerminalParser.term(","))).optional(), DeclarationParser.body(member)});
    }

    static Parser<Declaration> interfaceDef(Parser<Modifier> mod, Parser<Member> member) {
        return DeclarationParser.curry(InterfaceDef.class, new Object[0]).sequence(new Parser[]{mod.many(), TerminalParser.term("interface"), Terminals.Identifier.PARSER, TYPE_PARAMETERS.optional(), TerminalParser.term("extends").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL.sepBy1(TerminalParser.term(","))).optional(), DeclarationParser.body(member)});
    }

    static Parser<Declaration> annotationDef(Parser<Modifier> mod, Parser<Member> member) {
        return DeclarationParser.curry(AnnotationDef.class, new Object[0]).sequence(new Parser[]{mod.many(), TerminalParser.phrase("@ interface"), Terminals.Identifier.PARSER, DeclarationParser.body(member)});
    }

    static Parser<Declaration> enumDef(Parser<Expression> expr, Parser<Member> member) {
        Parser enumValue = Mapper.curry(EnumDef.Value.class, (Object[])new Object[0]).sequence(new Parser[]{Terminals.Identifier.PARSER, Parsers.between(TerminalParser.term("("), (Parser)expr.sepBy(TerminalParser.term(",")), TerminalParser.term(")")).optional(), Parsers.between(TerminalParser.term("{"), (Parser)member.many(), TerminalParser.term("}")).optional()});
        return DeclarationParser.curry(EnumDef.class, new Object[0]).sequence(new Parser[]{StatementParser.modifier(expr).many(), TerminalParser.term("enum"), Terminals.Identifier.PARSER, TerminalParser.term("implements").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL.sepBy1(TerminalParser.term(","))).optional(), TerminalParser.term("{"), enumValue.sepBy(TerminalParser.term(",")), TerminalParser.term(";").next(member.many()).optional(), TerminalParser.term("}")});
    }

    public static Parser<Program> program() {
        Parser.Reference memberRef = Parser.newReference();
        Parser<Expression> expr = ExpressionParser.expression(DeclarationParser.body((Parser<Member>)memberRef.lazy()));
        Parser<Statement> stmt = StatementParser.statement(expr);
        Parser<Modifier> mod = StatementParser.modifier(expr);
        Parser.Reference decRef = Parser.newReference();
        Parser member = Parsers.or(DeclarationParser.fieldDef(expr), DeclarationParser.methodDef(mod, expr, stmt), DeclarationParser.constructorDef(mod, stmt), DeclarationParser.initializerDef(stmt), DeclarationParser.nestedDef((Parser<Declaration>)decRef.lazy()));
        memberRef.set((Object)member);
        Parser declaration = Parsers.or(DeclarationParser.classDef(mod, (Parser<Member>)member), DeclarationParser.interfaceDef(mod, (Parser<Member>)member), DeclarationParser.enumDef(expr, (Parser<Member>)member), DeclarationParser.annotationDef(mod, (Parser<Member>)member));
        decRef.set((Object)declaration);
        return Mapper.curry(Program.class, (Object[])new Object[0]).sequence(new Parser[]{PACKAGE.optional(), IMPORT.many(), declaration.many()});
    }

    public static Program parse(String source) {
        return TerminalParser.parse(DeclarationParser.program(), source);
    }

    public static Program parse(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            Program program = TerminalParser.parse(DeclarationParser.program(), new InputStreamReader(in, Charset.forName("UTF-8")), url.toString());
            return program;
        }
        finally {
            in.close();
        }
    }

    private static Mapper<Declaration> curry(Class<? extends Declaration> clazz, Object ... curryArgs) {
        return Mapper.curry(clazz, (Object[])curryArgs);
    }
}

