/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.common;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ValueObject {
    private volatile List<Object> fieldValues = null;
    private static final Comparator<Field> NAME_ORDER = new Comparator<Field>(){

        @Override
        public int compare(Field field1, Field field2) {
            return field1.getName().compareTo(field2.getName());
        }
    };
    private static final ConcurrentMap<Class<?>, Field[]> valueFieldMap = new ConcurrentHashMap();
    private static final Field[] NO_FIELD = new Field[0];

    private List<Object> valueList() {
        if (this.fieldValues == null) {
            this.fieldValues = Collections.unmodifiableList(ValueObject.toValueList(this, ValueObject.getValueFields(this.getClass())));
        }
        return this.fieldValues;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.valueList().equals(((ValueObject)obj).valueList());
    }

    public int hashCode() {
        return this.valueList().hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName());
        buf.append(" {");
        Field[] fields = ValueObject.getValueFields(this.getClass());
        int i = 0;
        for (Object value : this.valueList()) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(fields[i++].getName()).append('=').append(value);
        }
        buf.append('}');
        return buf.toString();
    }

    private static Field[] getValueFields(Class<?> type) {
        Field[] fields = (Field[])valueFieldMap.get(type);
        if (fields == null) {
            fields = ValueObject.introspectValueFields(type);
            valueFieldMap.put(type, fields);
        }
        return fields;
    }

    private static List<Object> toValueList(Object obj, Field[] fields) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Field field : fields) {
            try {
                list.add(field.get(obj));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    private static Field[] introspectValueFields(Class<?> type) {
        if (type == ValueObject.class) {
            return NO_FIELD;
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.addAll(Arrays.asList(ValueObject.introspectValueFields(type.getSuperclass())));
        List<Field> myFields = ValueObject.tail(fieldList);
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            myFields.add(field);
        }
        Collections.sort(myFields, NAME_ORDER);
        AccessibleObject[] fields = fieldList.toArray(new Field[fieldList.size()]);
        AccessibleObject.setAccessible(fields, true);
        return fields;
    }

    private static <T> List<T> tail(List<T> list) {
        int size = list.size();
        return list.subList(size, size);
    }
}

