/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.java.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Scanners;
import org.codehaus.jparsec.Terminals;
import org.codehaus.jparsec.Token;
import org.codehaus.jparsec.examples.java.parser.JavaLexer;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.misc.Mapper;

public final class TerminalParser {
    private static final String[] OPERATORS = new String[]{"+", "-", "*", "/", "%", "&", "|", "~", "^", ">", "<", "==", ">=", "<=", "!=", "&&", "||", "!", ".", ",", "?", ":", ";", "...", "@", "=", "+=", "-=", "*=", "/=", "%=", "^=", "&=", "|=", "<<=", ">>=", ">>>=", "++", "--", "(", ")", "[", "]", "{", "}"};
    private static final String[] KEYWORDS = new String[]{"private", "protected", "public", "final", "abstract", "native", "static", "transient", "volatile", "throws", "class", "interface", "enum", "package", "import", "if", "else", "for", "while", "do", "continue", "break", "return", "switch", "case", "default", "throw", "try", "catch", "finally", "new", "this", "super", "synchronized", "instanceof", "extends", "implements", "assert", "byte", "short", "int", "long", "char", "float", "double", "boolean", "char", "void", "true", "false", "null", "goto", "const", "strictfp"};
    private static final Terminals TERMS = Terminals.operators((String[])OPERATORS).words(JavaLexer.IDENTIFIER).keywords(KEYWORDS).build();
    static final Parser<?> TOKENIZER = Parsers.or(JavaLexer.SCIENTIFIC_NUMBER_LITERAL, (Parser)Terminals.StringLiteral.DOUBLE_QUOTE_TOKENIZER, (Parser)Terminals.CharLiteral.SINGLE_QUOTE_TOKENIZER, (Parser)TERMS.tokenizer(), JavaLexer.DECIMAL_POINT_NUMBER, JavaLexer.INTEGER);

    public static Parser<Token> adjacent(Parser<List<Token>> parser, final String name) {
        return parser.next((Map)new Map<List<Token>, Parser<Object>>(){

            public Parser<Object> map(List<Token> tokens) {
                if (tokens.isEmpty()) {
                    return Parsers.always();
                }
                int offset = tokens.get(0).index();
                for (Token token : tokens) {
                    if (token.index() != offset) {
                        return Parsers.expect((String)name);
                    }
                    offset += token.length();
                }
                return Parsers.always();
            }
        }).atomic().source().token();
    }

    public static Parser<Token> adjacent(String operator) {
        ArrayList<Parser> parsers = new ArrayList<Parser>(operator.length());
        for (int i = 0; i < operator.length(); ++i) {
            parsers.add(TERMS.token(Character.toString(operator.charAt(i))));
        }
        return TerminalParser.adjacent((Parser<List<Token>>)Parsers.list(parsers), operator);
    }

    public static Parser<?> term(String name) {
        if (name.equals(">>")) {
            return TerminalParser.adjacent(">>>").not().next(TerminalParser.adjacent(">>"));
        }
        if (name.equals("<<") || name.equals(">>>")) {
            return TerminalParser.adjacent(name);
        }
        return Mapper._((Parser)TERMS.token(name));
    }

    static Parser<?> oneOf(String ... names) {
        return Mapper._((Parser)TERMS.token(names));
    }

    static <T> T parse(Parser<T> parser, String source) {
        return (T)parser.from(TOKENIZER, Scanners.JAVA_DELIMITER).parse((CharSequence)source);
    }

    static <T> T parse(Parser<T> parser, Readable readable, String module) throws IOException {
        return (T)parser.from(TOKENIZER, Scanners.JAVA_DELIMITER).parse(readable, module);
    }

    public static Parser<?> phrase(String phrase) {
        return Mapper._((Parser)TERMS.phrase(phrase.split("\\s+")));
    }
}

