/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.java.parser;

import java.util.List;
import org.codehaus.jparsec.OperatorTable;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Terminals;
import org.codehaus.jparsec.examples.java.ast.declaration.DefBody;
import org.codehaus.jparsec.examples.java.ast.expression.ArrayInitializer;
import org.codehaus.jparsec.examples.java.ast.expression.ArraySubscriptExpression;
import org.codehaus.jparsec.examples.java.ast.expression.BinaryExpression;
import org.codehaus.jparsec.examples.java.ast.expression.BooleanLiteral;
import org.codehaus.jparsec.examples.java.ast.expression.CastExpression;
import org.codehaus.jparsec.examples.java.ast.expression.CharLiteral;
import org.codehaus.jparsec.examples.java.ast.expression.ClassLiteral;
import org.codehaus.jparsec.examples.java.ast.expression.ConditionalExpression;
import org.codehaus.jparsec.examples.java.ast.expression.DecimalPointNumberLiteral;
import org.codehaus.jparsec.examples.java.ast.expression.Expression;
import org.codehaus.jparsec.examples.java.ast.expression.Identifier;
import org.codehaus.jparsec.examples.java.ast.expression.InstanceOfExpression;
import org.codehaus.jparsec.examples.java.ast.expression.IntegerLiteral;
import org.codehaus.jparsec.examples.java.ast.expression.MethodCallExpression;
import org.codehaus.jparsec.examples.java.ast.expression.NewArrayExpression;
import org.codehaus.jparsec.examples.java.ast.expression.NewExpression;
import org.codehaus.jparsec.examples.java.ast.expression.NullExpression;
import org.codehaus.jparsec.examples.java.ast.expression.Operator;
import org.codehaus.jparsec.examples.java.ast.expression.PostfixUnaryExpression;
import org.codehaus.jparsec.examples.java.ast.expression.PrefixUnaryExpression;
import org.codehaus.jparsec.examples.java.ast.expression.QualifiedExpression;
import org.codehaus.jparsec.examples.java.ast.expression.ScientificNumberLiteral;
import org.codehaus.jparsec.examples.java.ast.expression.StringLiteral;
import org.codehaus.jparsec.examples.java.ast.expression.SuperExpression;
import org.codehaus.jparsec.examples.java.ast.expression.ThisExpression;
import org.codehaus.jparsec.examples.java.ast.type.ArrayTypeLiteral;
import org.codehaus.jparsec.examples.java.ast.type.TypeLiteral;
import org.codehaus.jparsec.examples.java.parser.TerminalParser;
import org.codehaus.jparsec.examples.java.parser.TypeLiteralParser;
import org.codehaus.jparsec.functors.Binary;
import org.codehaus.jparsec.functors.Unary;
import org.codehaus.jparsec.misc.Mapper;

public final class ExpressionParser {
    static final Parser<Expression> NULL = TerminalParser.term("null").retn((Object)NullExpression.instance);
    static final Parser<Unary<Expression>> INSTANCE_OF = ExpressionParser.curry(InstanceOfExpression.class, new Object[0]).postfix(new Parser[]{TerminalParser.term("instanceof"), TypeLiteralParser.TYPE_LITERAL});
    static final Parser<Unary<Expression>> QUALIFIED_EXPR = ExpressionParser.curry(QualifiedExpression.class, new Object[0]).postfix(new Parser[]{TerminalParser.term("."), Terminals.Identifier.PARSER});
    static final Parser<Expression> THIS = ExpressionParser.curry(ThisExpression.class, new Object[0]).sequence(new Parser[]{Terminals.Identifier.PARSER.followedBy(TerminalParser.term(".")).many(), TerminalParser.term("this")});
    static final Parser<Expression> SUPER = TerminalParser.term("super").retn((Object)new SuperExpression());
    static final Parser<Expression> IDENTIFIER = ExpressionParser.curry(Identifier.class, new Object[0]).sequence(new Parser[]{Terminals.Identifier.PARSER});
    static final Parser<Expression> CLASS_LITERAL = ExpressionParser.curry(ClassLiteral.class, new Object[0]).sequence(new Parser[]{TypeLiteralParser.TYPE_LITERAL, TerminalParser.phrase(". class")});
    static final Parser<Expression> INTEGER_LITERAL = Parsers.tokenType(IntegerLiteral.class, (String)"integer literal");
    static final Parser<Expression> DECIMAL_LITERAL = Parsers.tokenType(DecimalPointNumberLiteral.class, (String)"decimal number literal");
    static final Parser<Expression> STRING_LITERAL = ExpressionParser.curry(StringLiteral.class, new Object[0]).sequence(new Parser[]{Terminals.StringLiteral.PARSER});
    static final Parser<Expression> CHAR_LITERAL = ExpressionParser.curry(CharLiteral.class, new Object[0]).sequence(new Parser[]{Terminals.CharLiteral.PARSER});
    static final Parser<Expression> BOOLEAN_LITERAL = Parsers.or((Parser)TerminalParser.term("true").retn((Object)new BooleanLiteral(true)), (Parser)TerminalParser.term("false").retn((Object)new BooleanLiteral(false)));
    static final Parser<Expression> SCIENTIFIC_LITERAL = Parsers.tokenType(ScientificNumberLiteral.class, (String)"scientific number literal");
    static final Parser<Expression> ATOM = Parsers.or((Parser[])new Parser[]{NULL, THIS, SUPER, CLASS_LITERAL, BOOLEAN_LITERAL, CHAR_LITERAL, STRING_LITERAL, SCIENTIFIC_LITERAL, INTEGER_LITERAL, DECIMAL_LITERAL, IDENTIFIER});

    static Parser<Binary<Expression>> conditional(Parser<Expression> consequence) {
        return ExpressionParser.curry(ConditionalExpression.class, new Object[0]).infix(new Parser[]{TerminalParser.term("?"), consequence, TerminalParser.term(":")});
    }

    static final Parser<Expression> castOrExpression(Parser<Expression> expr) {
        return ExpressionParser.curry(CastExpression.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("("), TypeLiteralParser.TYPE_LITERAL, TerminalParser.term(")"), expr}).or(ExpressionParser.paren(expr));
    }

    static Parser<Unary<Expression>> subscript(Parser<Expression> expr) {
        return ExpressionParser.curry(ArraySubscriptExpression.class, new Object[0]).postfix(new Parser[]{TerminalParser.term("["), expr, TerminalParser.term("]")});
    }

    static Parser<Unary<Expression>> qualifiedMethodCall(Parser<Expression> arg) {
        return ExpressionParser.curry(MethodCallExpression.class, new Object[0]).postfix(new Parser[]{TerminalParser.term("."), TypeLiteralParser.optionalTypeArgs(TypeLiteralParser.TYPE_LITERAL), Terminals.Identifier.PARSER, ExpressionParser.argumentList(arg)});
    }

    static Parser<Unary<Expression>> qualifiedNew(Parser<Expression> arg, Parser<DefBody> body) {
        return ExpressionParser.curry(NewExpression.class, new Object[0]).postfix(new Parser[]{TerminalParser.phrase(". new"), TypeLiteralParser.ELEMENT_TYPE_LITERAL, ExpressionParser.argumentList(arg), body.optional()});
    }

    static Parser<Expression> simpleMethodCall(Parser<Expression> arg) {
        return new Mapper<Expression>(){

            Expression map(String name, List<Expression> args) {
                return new MethodCallExpression(null, TypeLiteralParser.EMPTY_TYPE_ARGUMENT_LIST, name, args);
            }
        }.sequence(new Parser[]{Terminals.Identifier.PARSER, ExpressionParser.argumentList(arg)});
    }

    static Parser<Expression> simpleNewExpression(Parser<Expression> arg, Parser<DefBody> body) {
        return new Mapper<Expression>(){

            Expression map(TypeLiteral type, List<Expression> args, DefBody defBody) {
                return new NewExpression(null, type, args, defBody);
            }
        }.sequence(new Parser[]{TerminalParser.term("new"), TypeLiteralParser.ELEMENT_TYPE_LITERAL, ExpressionParser.argumentList(arg), body.optional()});
    }

    static Parser<Expression> newArrayWithExplicitLength(Parser<Expression> expr) {
        return new Mapper<Expression>(){

            Expression map(TypeLiteral type, Expression length, List<Expression> values) {
                return new NewArrayExpression(type, length, values);
            }
        }.sequence(new Parser[]{TerminalParser.term("new"), TypeLiteralParser.TYPE_LITERAL, TerminalParser.term("["), expr, TerminalParser.term("]"), Parsers.between(TerminalParser.term("{"), (Parser)expr.sepBy(TerminalParser.term(",")), TerminalParser.term("}")).optional()});
    }

    static Parser<Expression> newArrayWithoutExplicitLength(Parser<Expression> expr) {
        return new Mapper<Expression>(){

            Expression map(ArrayTypeLiteral type, List<Expression> values) {
                return new NewArrayExpression(type.elementType, null, values);
            }
        }.sequence(new Parser[]{TerminalParser.term("new"), TypeLiteralParser.ARRAY_TYPE_LITERAL, TerminalParser.term("{"), expr.sepBy(TerminalParser.term(",")), TerminalParser.term("}")});
    }

    static <T> Parser<T> paren(Parser<T> parser) {
        return parser.between(TerminalParser.term("("), TerminalParser.term(")"));
    }

    private static Parser<List<Expression>> argumentList(Parser<Expression> arg) {
        return ExpressionParser.paren(arg.sepBy(TerminalParser.term(",")));
    }

    static Parser<Expression> expression(Parser<Expression> atom, Parser<DefBody> classBody) {
        Parser.Reference ref = Parser.newReference();
        Parser lazy = ref.lazy();
        atom = Parsers.or(ExpressionParser.castOrExpression((Parser<Expression>)lazy), ExpressionParser.simpleNewExpression((Parser<Expression>)lazy, classBody), ExpressionParser.newArrayWithExplicitLength((Parser<Expression>)lazy), ExpressionParser.newArrayWithoutExplicitLength((Parser<Expression>)lazy), ExpressionParser.simpleMethodCall((Parser<Expression>)lazy), atom);
        Parser parser = new OperatorTable().postfix(ExpressionParser.subscript((Parser<Expression>)lazy), 200).postfix(ExpressionParser.qualifiedMethodCall((Parser<Expression>)lazy), 200).postfix(ExpressionParser.qualifiedNew((Parser<Expression>)lazy, classBody), 200).postfix(QUALIFIED_EXPR, 200).postfix(ExpressionParser.postfix(Operator.POST_INC), 200).postfix(ExpressionParser.postfix(Operator.POST_DEC), 200).prefix(ExpressionParser.prefix(Operator.INC), 190).prefix(ExpressionParser.prefix(Operator.DEC), 190).prefix(ExpressionParser.prefix(Operator.POSITIVE), 190).prefix(ExpressionParser.prefix(Operator.NEGATIVE), 190).prefix(ExpressionParser.prefix(Operator.INC), 190).prefix(ExpressionParser.prefix(Operator.DEC), 190).prefix(ExpressionParser.prefix(Operator.NOT), 190).prefix(ExpressionParser.prefix(Operator.BITWISE_NOT), 190).infixl(ExpressionParser.binary(Operator.MUL), 100).infixl(ExpressionParser.binary(Operator.DIV), 100).infixl(ExpressionParser.binary(Operator.MOD), 100).infixl(ExpressionParser.binary(Operator.DIV), 100).infixl(ExpressionParser.binary(Operator.PLUS), 90).infixl(ExpressionParser.binary(Operator.MINUS), 90).infixl(ExpressionParser.binary(Operator.LSHIFT), 80).infixl(ExpressionParser.binary(Operator.RSHIFT), 80).infixl(ExpressionParser.binary(Operator.UNSIGNED_RSHIFT), 80).infixl(ExpressionParser.binary(Operator.LE), 70).infixl(ExpressionParser.binary(Operator.GE), 70).infixl(ExpressionParser.binary(Operator.LT), 70).infixl(ExpressionParser.binary(Operator.GT), 70).postfix(INSTANCE_OF, 65).infixl(ExpressionParser.binary(Operator.EQ), 60).infixl(ExpressionParser.binary(Operator.NE), 60).infixl(ExpressionParser.binary(Operator.BITWISE_AND), 50).infixl(ExpressionParser.binary(Operator.BITWISE_XOR), 40).infixl(ExpressionParser.binary(Operator.BITWISE_OR), 30).infixl(ExpressionParser.binary(Operator.AND), 20).infixl(ExpressionParser.binary(Operator.OR), 10).infixr(ExpressionParser.conditional((Parser<Expression>)lazy), 5).infixr(ExpressionParser.binary(Operator.ASSIGNMENT), 0).infixr(ExpressionParser.binary(Operator.APLUS), 0).infixr(ExpressionParser.binary(Operator.AMINUS), 0).infixr(ExpressionParser.binary(Operator.AMUL), 0).infixr(ExpressionParser.binary(Operator.ADIV), 0).infixr(ExpressionParser.binary(Operator.AMOD), 0).infixr(ExpressionParser.binary(Operator.AAND), 0).infixr(ExpressionParser.binary(Operator.AOR), 0).infixr(ExpressionParser.binary(Operator.AXOR), 0).infixr(ExpressionParser.binary(Operator.ALSHIFT), 0).infixr(ExpressionParser.binary(Operator.ARSHIFT), 0).infixr(ExpressionParser.binary(Operator.UNSIGNED_ARSHIFT), 0).build(atom);
        ref.set((Object)parser);
        return parser;
    }

    public static Parser<Expression> expression(Parser<DefBody> classBody) {
        return ExpressionParser.expression(ATOM, classBody);
    }

    public static Parser<Expression> arrayInitializer(Parser<Expression> expr) {
        return ExpressionParser.curry(ArrayInitializer.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("{"), expr.sepEndBy(TerminalParser.term(",")), TerminalParser.term("}")});
    }

    static Parser<Expression> arrayInitializerOrRegularExpression(Parser<Expression> expr) {
        return ExpressionParser.arrayInitializer(expr).or(expr);
    }

    private static Parser<Binary<Expression>> binary(Operator op) {
        return TerminalParser.term(op.toString()).next(ExpressionParser.curry(BinaryExpression.class, new Object[]{op}).binary());
    }

    private static Parser<Unary<Expression>> prefix(Operator op) {
        return TerminalParser.term(op.toString()).next(ExpressionParser.curry(PrefixUnaryExpression.class, new Object[]{op}).unary());
    }

    private static Parser<Unary<Expression>> postfix(Operator op) {
        return TerminalParser.term(op.toString()).next(ExpressionParser.curry(PostfixUnaryExpression.class, new Object[]{op}).unary());
    }

    static Mapper<Expression> curry(Class<? extends Expression> clazz, Object ... args) {
        return Mapper.curry(clazz, (Object[])args);
    }
}

