/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.message.serializer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.joyqueue.broker.kafka.command.SyncGroupAssignment;
import org.joyqueue.network.serializer.Serializer;

public class KafkaSyncGroupAssignmentSerializer {
    private static final short HEADER_VERSION = 0;

    public static SyncGroupAssignment readAssignment(ByteBuf buffer) throws Exception {
        int length = buffer.readInt();
        short headerVersion = buffer.readShort();
        HashMap topicPartitions = Maps.newHashMap();
        int topicSize = buffer.readInt();
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString((ByteBuf)buffer, (int)2);
            int partitionSize = buffer.readInt();
            ArrayList partitions = partitionSize == -1 ? Collections.emptyList() : Lists.newArrayListWithCapacity((int)partitionSize);
            for (int j = 0; j < partitionSize; ++j) {
                partitions.add(buffer.readInt());
            }
            topicPartitions.put(topic, partitions);
        }
        int userDataLength = buffer.readInt();
        byte[] userData = null;
        if (userDataLength > 0) {
            userData = new byte[userDataLength];
            buffer.readBytes(userData);
        }
        SyncGroupAssignment syncGroupAssignment = new SyncGroupAssignment();
        syncGroupAssignment.setUserData(userData);
        syncGroupAssignment.setTopicPartitions(topicPartitions);
        return syncGroupAssignment;
    }

    public static void writeAssignment(ByteBuf buffer, SyncGroupAssignment assignment) throws Exception {
        int writerIndex = buffer.writerIndex();
        buffer.writeInt(0);
        buffer.writeShort(0);
        buffer.writeInt(assignment.getTopicPartitions().keySet().size());
        for (Map.Entry<String, List<Integer>> entry : assignment.getTopicPartitions().entrySet()) {
            String topic = entry.getKey();
            List<Integer> partitions = entry.getValue();
            Serializer.write((String)topic, (ByteBuf)buffer, (int)2);
            if (CollectionUtils.isEmpty(partitions)) {
                buffer.writeInt(-1);
                continue;
            }
            buffer.writeInt(partitions.size());
            for (Integer partition : partitions) {
                buffer.writeInt(partition.intValue());
            }
        }
        if (ArrayUtils.isEmpty((byte[])assignment.getUserData())) {
            buffer.writeInt(0);
        } else {
            buffer.writeInt(assignment.getUserData().length);
            buffer.writeBytes(assignment.getUserData());
        }
        buffer.setInt(writerIndex, buffer.writerIndex() - writerIndex - 4);
    }
}

