/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import org.joyqueue.broker.kafka.KafkaCommandHandler;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.InitProducerIdRequest;
import org.joyqueue.broker.kafka.command.InitProducerIdResponse;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionCoordinator;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionMetadata;
import org.joyqueue.broker.kafka.coordinator.transaction.exception.TransactionException;
import org.joyqueue.broker.kafka.helper.KafkaClientHelper;
import org.joyqueue.network.protocol.annotation.ProduceHandler;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProduceHandler
public class InitProducerIdRequestHandler
implements KafkaCommandHandler,
Type,
KafkaContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(InitProducerIdRequestHandler.class);
    private TransactionCoordinator transactionCoordinator;

    @Override
    public void setKafkaContext(KafkaContext kafkaContext) {
        this.transactionCoordinator = kafkaContext.getTransactionCoordinator();
    }

    public Command handle(Transport transport, Command command) {
        InitProducerIdRequest initProducerIdRequest = (InitProducerIdRequest)command.getPayload();
        String clientId = KafkaClientHelper.parseClient(initProducerIdRequest.getClientId());
        InitProducerIdResponse response = null;
        try {
            TransactionMetadata transactionMetadata = this.transactionCoordinator.handleInitProducer(clientId, initProducerIdRequest.getTransactionId(), initProducerIdRequest.getTransactionTimeout());
            response = new InitProducerIdResponse(KafkaErrorCode.NONE.getCode(), transactionMetadata.getProducerId(), transactionMetadata.getProducerEpoch());
        }
        catch (TransactionException e) {
            logger.warn("init producerId exception, code: {}, message: {}, request: {}, code: {}", new Object[]{e.getCode(), e.getMessage(), initProducerIdRequest, e.getCode()});
            response = new InitProducerIdResponse((short)e.getCode(), -1L, -1);
        }
        catch (Exception e) {
            logger.error("init producerId exception, request: {}", (Object)initProducerIdRequest, (Object)e);
            response = new InitProducerIdResponse(KafkaErrorCode.exceptionFor(e), -1L, -1);
        }
        return new Command((Object)response);
    }

    public int type() {
        return KafkaCommandType.INIT_PRODUCER_ID.getCode();
    }
}

