/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.config;

import org.joyqueue.domain.QosLevel;
import org.joyqueue.toolkit.config.PropertyDef;

public enum KafkaConfigKey implements PropertyDef
{
    SESSION_MIN_TIMEOUT("kafka.session.min.timeout.ms", 6000, PropertyDef.Type.INT),
    SESSION_MAX_TIMEOUT("kafka.session.max.timeout.ms", 300000, PropertyDef.Type.INT),
    REBALANCE_INITIAL_DELAY("kafka.rebalance.initial.delay", 3000, PropertyDef.Type.INT),
    REBALANCE_TIMEOUT("kafka.rebalance.timeout", 60000, PropertyDef.Type.INT),
    OFFSET_SYNC_TIMEOUT("kafka.offset.sync.timeout", 1000, PropertyDef.Type.INT),
    TRANSACTION_SYNC_TIMEOUT("kafka.transaction.sync.timeout", 3000, PropertyDef.Type.INT),
    TRANSACTION_TIMEOUT("kafka.transaction.timeout", 1800000, PropertyDef.Type.INT),
    TRANSACTION_LOG_WRITE_QOSLEVEL("kafka.transaction.log.write.qosLevel", QosLevel.REPLICATION.value(), PropertyDef.Type.INT),
    TRANSACTION_LOG_RETRIES("kafka.transaction.log.reties", 3, PropertyDef.Type.INT),
    TRANSACTION_LOG_INTERVAL("kafka.transaction.log.interval", 60000, PropertyDef.Type.INT),
    TRANSACTION_LOG_SCAN_SIZE("kafka.transaction.log.scan.size", 1000, PropertyDef.Type.INT),
    TRANSACTION_PRODUCER_SEQUENCE_EXPIRE("kafka.transaction.producer.sequence.expire", 300000, PropertyDef.Type.INT),
    TRANSACTION_LOG_APP("coordinator.transaction.log.app", "__transaction_log", PropertyDef.Type.STRING),
    METADATA_DELAY_ENABLE("kafka.metadata.delay.enable", true, PropertyDef.Type.BOOLEAN),
    METADATA_DELAY("kafka.metadata.delay", 10000, PropertyDef.Type.INT),
    METADATA_CACHE_ENABLE("kafka.metadata.enable", true, PropertyDef.Type.BOOLEAN),
    METADATA_CACHE_EXPIRE_TIME("kafka.metadata.expire.time", 60000, PropertyDef.Type.INT),
    METADATA_FUZZY_SEARCH_ENABLE("kafka.metadata.fuzzy.enable", true, PropertyDef.Type.BOOLEAN),
    FETCH_DELAY("kafka.fetch.delay", true, PropertyDef.Type.BOOLEAN),
    PRODUCE_TIMEOUT("kafka.produce.timeout", 3000, PropertyDef.Type.INT),
    PRODUCE_DELAY_ENABLE("kafka.produce.delay.enable", true, PropertyDef.Type.BOOLEAN),
    PRODUCE_DELAY("kafka.produce.delay", 1000, PropertyDef.Type.INT),
    AUTH_ENABLE("kafka.auth.enable", false, PropertyDef.Type.BOOLEAN),
    AUTH_ENABLE_PREFIX("kafka.auth.enable.", null, PropertyDef.Type.BOOLEAN);

    private String name;
    private Object value;
    private PropertyDef.Type type;

    private KafkaConfigKey(String name, Object value, PropertyDef.Type type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public PropertyDef.Type getType() {
        return this.type;
    }
}

