/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashMap;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.SyncGroupAssignment;
import org.joyqueue.broker.kafka.command.SyncGroupRequest;
import org.joyqueue.broker.kafka.command.SyncGroupResponse;
import org.joyqueue.broker.kafka.message.serializer.KafkaSyncGroupAssignmentSerializer;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;

public class SyncGroupCodec
implements KafkaPayloadCodec<SyncGroupResponse>,
Type {
    public Object decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        SyncGroupRequest request = new SyncGroupRequest();
        HashMap groupAssignment = Collections.emptyMap();
        request.setGroupId(Serializer.readString((ByteBuf)buffer, (int)2));
        request.setGenerationId(buffer.readInt());
        request.setMemberId(Serializer.readString((ByteBuf)buffer, (int)2));
        int size = buffer.readInt();
        if (size > 0) {
            groupAssignment = Maps.newHashMap();
            for (int i = 0; i < size; ++i) {
                String memberId = Serializer.readString((ByteBuf)buffer, (int)2);
                SyncGroupAssignment assignment = KafkaSyncGroupAssignmentSerializer.readAssignment(buffer);
                groupAssignment.put(memberId, assignment);
            }
        }
        request.setGroupAssignment(groupAssignment);
        return request;
    }

    public void encode(SyncGroupResponse payload, ByteBuf buffer) throws Exception {
        if (payload.getVersion() >= 1) {
            buffer.writeInt(payload.getThrottleTimeMs());
        }
        buffer.writeShort((int)payload.getErrorCode());
        SyncGroupAssignment assignment = payload.getAssignment();
        if (assignment != null) {
            KafkaSyncGroupAssignmentSerializer.writeAssignment(buffer, assignment);
        } else {
            buffer.writeInt(0);
        }
    }

    public int type() {
        return KafkaCommandType.SYNC_GROUP.getCode();
    }
}

