/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.protocol;

import io.netty.buffer.ByteBuf;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaHeaderCodec
implements Codec {
    private static Logger logger = LoggerFactory.getLogger(KafkaHeaderCodec.class);

    public KafkaHeader decode(ByteBuf buffer) throws TransportException.CodecException {
        KafkaHeader kafkaHeader = new KafkaHeader();
        kafkaHeader.setApiKey(buffer.readShort());
        kafkaHeader.setApiVersion(buffer.readShort());
        kafkaHeader.setRequestId(buffer.readInt());
        try {
            kafkaHeader.setClientId(Serializer.readString((ByteBuf)buffer, (int)2));
        }
        catch (Exception e) {
            throw new TransportException.CodecException((Throwable)e);
        }
        if (kafkaHeader.getDirection() == null) {
            kafkaHeader.setDirection(Direction.REQUEST);
        }
        if (kafkaHeader.getQosLevel() == null) {
            kafkaHeader.setQosLevel(QosLevel.RECEIVE);
        }
        return kafkaHeader;
    }

    public void encode(Object obj, ByteBuf buffer) throws TransportException.CodecException {
        KafkaHeader kafkaHeader = (KafkaHeader)obj;
        buffer.writeInt(kafkaHeader.getRequestId());
    }
}

