/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.broker.kafka.command.OffsetFetchRequest;
import org.joyqueue.broker.kafka.command.OffsetFetchResponse;
import org.joyqueue.broker.kafka.config.KafkaConfig;
import org.joyqueue.broker.kafka.coordinator.group.GroupCoordinator;
import org.joyqueue.broker.kafka.handler.AbstractKafkaCommandHandler;
import org.joyqueue.broker.kafka.helper.KafkaClientHelper;
import org.joyqueue.broker.kafka.model.OffsetMetadataAndError;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetFetchRequestHandler
extends AbstractKafkaCommandHandler
implements KafkaContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(OffsetFetchRequestHandler.class);
    private GroupCoordinator groupCoordinator;
    private KafkaConfig config;

    @Override
    public void setKafkaContext(KafkaContext kafkaContext) {
        this.groupCoordinator = kafkaContext.getGroupCoordinator();
        this.config = kafkaContext.getConfig();
    }

    public Command handle(Transport transport, Command command) {
        OffsetFetchRequest offsetFetchRequest = (OffsetFetchRequest)command.getPayload();
        String groupId = KafkaClientHelper.parseClient(offsetFetchRequest.getClientId());
        Map<String, List<Integer>> topicAndPartitions = offsetFetchRequest.getTopicAndPartitions();
        Map<String, List<OffsetMetadataAndError>> result = this.groupCoordinator.handleFetchOffsets(groupId, topicAndPartitions);
        if (this.config.getLogDetail(offsetFetchRequest.getClientId())) {
            logger.info("fetch offset, transport: {}, app: {}, request: {}, response: {}", new Object[]{transport, offsetFetchRequest.getClientId(), offsetFetchRequest, result});
        }
        OffsetFetchResponse offsetFetchResponse = new OffsetFetchResponse(result);
        return new Command((Object)offsetFetchResponse);
    }

    public int type() {
        return KafkaCommandType.OFFSET_FETCH.getCode();
    }
}

