/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public enum KafkaCommandType {
    PRODUCE(0, 0, 7),
    FETCH(1, 2, 6),
    LIST_OFFSETS(2, 0, 3),
    METADATA(3, 0, 4),
    OFFSET_COMMIT(8, 0, 4),
    OFFSET_FETCH(9, 0, 4),
    FIND_COORDINATOR(10, 0, 2),
    JOIN_GROUP(11, 0, 3),
    HEARTBEAT(12, 0, 2),
    LEAVE_GROUP(13, 0, 2),
    SYNC_GROUP(14, 0, 2),
    DESCRIBE_GROUP(15, 0, 2),
    API_VERSIONS(18, 0, 3),
    INIT_PRODUCER_ID(22, 0, 0),
    ADD_PARTITIONS_TO_TXN(24, 0, 1),
    ADD_OFFSETS_TO_TXN(25, 0, 1),
    END_TXN(26, 0, 1),
    TXN_OFFSET_COMMIT(28, 0, 2),
    SASL_AUTHENTICATE(36, 0, 1),
    SASL_HANDSHAKE(17, 0, 1),
    CUSTOMER_COMMAND(100, false);

    private static final short MIN_VERSION = 0;
    private static final short MAX_VERSION = 0;
    private static final Map<Short, KafkaCommandType> TYPES;
    private short code;
    private short minVersion;
    private short maxVersion;
    private boolean export;

    private KafkaCommandType(int code) {
        this(code, true);
    }

    private KafkaCommandType(int code, boolean export) {
        this(code, 0, 0, export);
    }

    private KafkaCommandType(int code, int minVersion, int maxVersion) {
        this(code, minVersion, maxVersion, true);
    }

    private KafkaCommandType(int code, int minVersion, int maxVersion, boolean export) {
        this.code = (short)code;
        this.minVersion = (short)minVersion;
        this.maxVersion = (short)maxVersion;
        this.export = export;
    }

    public static KafkaCommandType valueOf(short type) {
        return TYPES.get(type);
    }

    public static boolean contains(short type) {
        return TYPES.containsKey(type);
    }

    public short getCode() {
        return this.code;
    }

    public short getMinVersion() {
        return this.minVersion;
    }

    public short getMaxVersion() {
        return this.maxVersion;
    }

    public boolean isExport() {
        return this.export;
    }

    static {
        HashMap types = Maps.newHashMap();
        for (KafkaCommandType kafkaCommandType : KafkaCommandType.values()) {
            types.put(kafkaCommandType.getCode(), kafkaCommandType);
        }
        TYPES = types;
    }
}

