/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.transaction.helper;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionDomain;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionMarker;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionOffset;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionPrepare;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionState;
import org.joyqueue.network.serializer.Serializer;

public class TransactionSerializer {
    private static final int MAGIC = -889275714;
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final byte PREPARE_TYPE = 0;
    private static final byte MARKER_TYPE = 1;
    private static final byte OFFSET_TYPE = 2;
    private static final int HEADER_FIX_LENGTH = 6;
    private static final int PREPARE_FIX_LENGTH = 41;
    private static final int MARKER_FIX_LENGTH = 29;
    private static final int OFFSET_FIX_LENGTH = 40;

    protected static int sizeOfPrepare(TransactionPrepare prepare) throws Exception {
        int size = 41;
        byte[] bytes = Serializer.getBytes((String)prepare.getTopic(), (Charset)Charsets.UTF_8);
        size += bytes == null ? 0 : bytes.length;
        bytes = Serializer.getBytes((String)prepare.getApp(), (Charset)Charsets.UTF_8);
        size += bytes == null ? 0 : bytes.length;
        bytes = Serializer.getBytes((String)prepare.getBrokerHost(), (Charset)Charsets.UTF_8);
        size += bytes == null ? 0 : bytes.length;
        bytes = Serializer.getBytes((String)prepare.getTransactionId(), (Charset)Charsets.UTF_8);
        return size += bytes == null ? 0 : bytes.length;
    }

    protected static void serializePrepare(ByteBuffer buffer, TransactionPrepare prepare) throws Exception {
        Serializer.write((String)prepare.getTopic(), (ByteBuffer)buffer, (int)2);
        buffer.putShort(prepare.getPartition());
        Serializer.write((String)prepare.getApp(), (ByteBuffer)buffer, (int)2);
        buffer.putInt(prepare.getBrokerId());
        Serializer.write((String)prepare.getBrokerHost(), (ByteBuffer)buffer, (int)1);
        buffer.putInt(prepare.getBrokerPort());
        Serializer.write((String)prepare.getTransactionId(), (ByteBuffer)buffer, (int)2);
        buffer.putLong(prepare.getProducerId());
        buffer.putShort(prepare.getProducerEpoch());
        buffer.putShort(prepare.getEpoch());
        buffer.putInt(prepare.getTimeout());
        buffer.putLong(prepare.getCreateTime());
    }

    protected static TransactionPrepare deserializePrepare(ByteBuffer buffer) throws Exception {
        TransactionPrepare prepare = new TransactionPrepare();
        prepare.setTopic(Serializer.readString((ByteBuffer)buffer, (int)2));
        prepare.setPartition(buffer.getShort());
        prepare.setApp(Serializer.readString((ByteBuffer)buffer, (int)2));
        prepare.setBrokerId(buffer.getInt());
        prepare.setBrokerHost(Serializer.readString((ByteBuffer)buffer, (int)1));
        prepare.setBrokerPort(buffer.getInt());
        prepare.setTransactionId(Serializer.readString((ByteBuffer)buffer, (int)2));
        prepare.setProducerId(buffer.getLong());
        prepare.setProducerEpoch(buffer.getShort());
        prepare.setEpoch(buffer.getShort());
        prepare.setTimeout(buffer.getInt());
        prepare.setCreateTime(buffer.getLong());
        return prepare;
    }

    protected static int sizeOfMarker(TransactionMarker marker) throws Exception {
        int size = 29;
        byte[] bytes = Serializer.getBytes((String)marker.getApp(), (Charset)Charsets.UTF_8);
        size += bytes == null ? 0 : bytes.length;
        bytes = Serializer.getBytes((String)marker.getTransactionId(), (Charset)Charsets.UTF_8);
        return size += bytes == null ? 0 : bytes.length;
    }

    protected static void serializeMarker(ByteBuffer buffer, TransactionMarker marker) throws Exception {
        Serializer.write((String)marker.getApp(), (ByteBuffer)buffer, (int)2);
        Serializer.write((String)marker.getTransactionId(), (ByteBuffer)buffer, (int)1);
        buffer.putLong(marker.getProducerId());
        buffer.putShort(marker.getProducerEpoch());
        buffer.putShort(marker.getEpoch());
        buffer.put((byte)marker.getState().getValue());
        buffer.putInt(marker.getTimeout());
        buffer.putLong(marker.getCreateTime());
    }

    protected static TransactionMarker deserializeMarker(ByteBuffer buffer) throws Exception {
        TransactionMarker marker = new TransactionMarker();
        marker.setApp(Serializer.readString((ByteBuffer)buffer, (int)2));
        marker.setTransactionId(Serializer.readString((ByteBuffer)buffer, (int)1));
        marker.setProducerId(buffer.getLong());
        marker.setProducerEpoch(buffer.getShort());
        marker.setEpoch(buffer.getShort());
        marker.setState(TransactionState.valueOf(buffer.get()));
        marker.setTimeout(buffer.getInt());
        marker.setCreateTime(buffer.getLong());
        return marker;
    }

    protected static int sizeOfOffset(TransactionOffset offset) throws Exception {
        int size = 40;
        byte[] bytes = Serializer.getBytes((String)offset.getTopic(), (Charset)Charsets.UTF_8);
        size += bytes == null ? 0 : bytes.length;
        bytes = Serializer.getBytes((String)offset.getApp(), (Charset)Charsets.UTF_8);
        size += bytes == null ? 0 : bytes.length;
        bytes = Serializer.getBytes((String)offset.getTransactionId(), (Charset)Charsets.UTF_8);
        return size += bytes == null ? 0 : bytes.length;
    }

    protected static void serializeOffset(ByteBuffer buffer, TransactionOffset offset) throws Exception {
        Serializer.write((String)offset.getTopic(), (ByteBuffer)buffer, (int)2);
        buffer.putShort(offset.getPartition());
        buffer.putLong(offset.getOffset());
        Serializer.write((String)offset.getApp(), (ByteBuffer)buffer, (int)2);
        Serializer.write((String)offset.getTransactionId(), (ByteBuffer)buffer, (int)2);
        buffer.putLong(offset.getProducerId());
        buffer.putShort(offset.getProducerEpoch());
        buffer.putShort(offset.getEpoch());
        buffer.putInt(offset.getTimeout());
        buffer.putLong(offset.getCreateTime());
    }

    protected static TransactionOffset deserializeOffset(ByteBuffer buffer) throws Exception {
        TransactionOffset transactionOffset = new TransactionOffset();
        transactionOffset.setTopic(Serializer.readString((ByteBuffer)buffer, (int)2));
        transactionOffset.setPartition(buffer.getShort());
        transactionOffset.setOffset(buffer.getLong());
        transactionOffset.setApp(Serializer.readString((ByteBuffer)buffer, (int)2));
        transactionOffset.setTransactionId(Serializer.readString((ByteBuffer)buffer, (int)2));
        transactionOffset.setProducerId(buffer.getLong());
        transactionOffset.setProducerEpoch(buffer.getShort());
        transactionOffset.setEpoch(buffer.getShort());
        transactionOffset.setTimeout(buffer.getInt());
        transactionOffset.setCreateTime(buffer.getLong());
        return transactionOffset;
    }

    public static byte[] serialize(TransactionDomain transactionDomain) throws Exception {
        ByteBuffer buffer = null;
        if (transactionDomain instanceof TransactionPrepare) {
            int size = TransactionSerializer.sizeOfPrepare((TransactionPrepare)transactionDomain) + 6;
            buffer = ByteBuffer.allocate(size);
            TransactionSerializer.serializeHeader(buffer, transactionDomain);
            TransactionSerializer.serializePrepare(buffer, (TransactionPrepare)transactionDomain);
        } else if (transactionDomain instanceof TransactionMarker) {
            int size = TransactionSerializer.sizeOfMarker((TransactionMarker)transactionDomain) + 6;
            buffer = ByteBuffer.allocate(size);
            TransactionSerializer.serializeHeader(buffer, transactionDomain);
            TransactionSerializer.serializeMarker(buffer, (TransactionMarker)transactionDomain);
        } else if (transactionDomain instanceof TransactionOffset) {
            int size = TransactionSerializer.sizeOfOffset((TransactionOffset)transactionDomain) + 6;
            buffer = ByteBuffer.allocate(size);
            TransactionSerializer.serializeHeader(buffer, transactionDomain);
            TransactionSerializer.serializeOffset(buffer, (TransactionOffset)transactionDomain);
        } else {
            throw new UnsupportedOperationException(String.format("unsupported transaction, type: %s", transactionDomain.getClass()));
        }
        return buffer.array();
    }

    public static TransactionDomain deserialize(ByteBuffer buffer) throws Exception {
        TransactionHeader header = TransactionSerializer.deserializeHeader(buffer);
        switch (header.getType()) {
            case 0: {
                return TransactionSerializer.deserializePrepare(buffer);
            }
            case 1: {
                return TransactionSerializer.deserializeMarker(buffer);
            }
            case 2: {
                return TransactionSerializer.deserializeOffset(buffer);
            }
        }
        throw new UnsupportedOperationException(String.format("unsupported transaction, type: %s", header.getType()));
    }

    protected static void serializeHeader(ByteBuffer buffer, TransactionDomain transactionDomain) throws Exception {
        byte type = -1;
        if (transactionDomain instanceof TransactionPrepare) {
            type = 0;
        } else if (transactionDomain instanceof TransactionMarker) {
            type = 1;
        } else if (transactionDomain instanceof TransactionOffset) {
            type = 2;
        } else {
            throw new UnsupportedOperationException(String.format("unsupported transaction, type: %s", transactionDomain.getClass()));
        }
        buffer.putInt(-889275714);
        buffer.put((byte)0);
        buffer.put(type);
    }

    protected static TransactionHeader deserializeHeader(ByteBuffer buffer) {
        int magic = buffer.getInt();
        byte version = buffer.get();
        byte type = buffer.get();
        return new TransactionHeader(version, type);
    }

    private static class TransactionHeader {
        private byte version;
        private byte type;

        TransactionHeader() {
        }

        TransactionHeader(byte version, byte type) {
            this.version = version;
            this.type = type;
        }

        public byte getVersion() {
            return this.version;
        }

        public void setVersion(byte version) {
            this.version = version;
        }

        public byte getType() {
            return this.type;
        }

        public void setType(byte type) {
            this.type = type;
        }
    }
}

