/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.group.domain;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupMemberMetadata;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupState;
import org.joyqueue.broker.kafka.model.OffsetAndMetadata;
import org.joyqueue.toolkit.time.SystemClock;

public class GroupMetadata
extends org.joyqueue.broker.coordinator.group.domain.GroupMetadata {
    private GroupState state = GroupState.EMPTY;
    private int generationId = 0;
    private String leaderId;
    private String protocol;
    private String protocolType;
    private boolean newMemberAdded = false;
    private GroupState preState;
    private long preStateTimestamp;
    private Table<String, Integer, OffsetAndMetadata> offsetCache = HashBasedTable.create();
    private static final Map<GroupState, Set<GroupState>> ValidPreviousStates = Maps.newHashMap();

    public GroupMetadata(String groupId, String protocolType) {
        this.setId(groupId);
        this.protocolType = protocolType;
    }

    public GroupState getState() {
        return this.state;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public String getLeaderId() {
        return this.leaderId;
    }

    public int getGenerationId() {
        return this.generationId;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isNewMemberAdded() {
        return this.newMemberAdded;
    }

    public void setLeaderId(String leaderId) {
        this.leaderId = leaderId;
    }

    public void setNewMemberAdded(boolean newMemberAdded) {
        this.newMemberAdded = newMemberAdded;
    }

    public GroupState getPreState() {
        return this.preState;
    }

    public long getPreStateTimestamp() {
        return this.preStateTimestamp;
    }

    public Map<String, Map<Integer, OffsetAndMetadata>> getOffsetCache() {
        return this.offsetCache.rowMap();
    }

    public OffsetAndMetadata getOffsetCache(String topic, int partition) {
        return (OffsetAndMetadata)this.offsetCache.get((Object)topic, (Object)partition);
    }

    public void putOffsetCache(String topic, int partition, OffsetAndMetadata offsetAndMetadata) {
        this.offsetCache.put((Object)topic, (Object)partition, (Object)offsetAndMetadata);
    }

    public OffsetAndMetadata removeOffsetCache(String topic, int partition) {
        return (OffsetAndMetadata)this.offsetCache.remove((Object)topic, (Object)partition);
    }

    public void clearOffsetCache() {
        this.offsetCache.clear();
    }

    public boolean stateIs(GroupState groupState) {
        return this.state == groupState;
    }

    public boolean stateNot(GroupState groupState) {
        return this.state != groupState;
    }

    public boolean isHasMember(String memberId) {
        if (StringUtils.isBlank((CharSequence)memberId)) {
            return false;
        }
        return this.getMembers().containsKey(memberId);
    }

    public GroupMemberMetadata getMember(String memberId) {
        if (StringUtils.isBlank((CharSequence)memberId)) {
            return null;
        }
        return (GroupMemberMetadata)((Object)this.getMembers().get(memberId));
    }

    public boolean isNewGroup() {
        return this.generationId == 0;
    }

    public void addMember(GroupMemberMetadata member) {
        if (StringUtils.isBlank((CharSequence)this.leaderId)) {
            this.leaderId = member.getId();
        }
        super.addMember((org.joyqueue.broker.coordinator.group.domain.GroupMemberMetadata)member);
    }

    public void removeMember(String memberId) {
        this.getMembers().remove(memberId);
        if (memberId.equals(this.leaderId)) {
            if (this.getMembers().isEmpty()) {
                this.leaderId = null;
            } else {
                Set memberIds = this.getMembers().keySet();
                this.leaderId = (String)memberIds.iterator().next();
            }
        }
    }

    public boolean isMemberEmpty() {
        return this.getMembers().isEmpty();
    }

    public List<GroupMemberMetadata> getNotYetRejoinedMembers() {
        LinkedList result = Lists.newLinkedList();
        for (Map.Entry entry : this.getMembers().entrySet()) {
            GroupMemberMetadata member = (GroupMemberMetadata)((Object)entry.getValue());
            if (member.getAwaitingJoinCallback() != null) continue;
            result.add(member);
        }
        return result;
    }

    public List<String> getAllMemberIds() {
        return Lists.newArrayList(this.getMembers().keySet());
    }

    public List<GroupMemberMetadata> getAllMembers() {
        ConcurrentMap members = this.getMembers();
        if (MapUtils.isEmpty((Map)members)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)members.size());
        for (Map.Entry entry : members.entrySet()) {
            result.add((GroupMemberMetadata)((Object)entry.getValue()));
        }
        return result;
    }

    public int getMaxRebalanceTimeout() {
        if (MapUtils.isEmpty((Map)this.getMembers())) {
            return 0;
        }
        int result = 0;
        for (Map.Entry entry : this.getMembers().entrySet()) {
            result = Math.max(((GroupMemberMetadata)((Object)entry.getValue())).getRebalanceTimeoutMs(), result);
        }
        return result;
    }

    public boolean canRebalance() {
        return this.state == GroupState.EMPTY || this.state == GroupState.STABLE || this.state == GroupState.AWAITINGSYNC;
    }

    public void transitionStateTo(GroupState groupState) {
        this.assertValidTransition(groupState);
        this.preState = this.state;
        this.preStateTimestamp = SystemClock.now();
        this.state = groupState;
    }

    public String getExtension() {
        return String.format("{state: '%s', preState: '%s', preStateTimestamp: %s, leader: '%s', generationId: '%s', protocol: '%s'}", new Object[]{this.state, this.preState, this.preStateTimestamp, this.leaderId, this.generationId, this.protocol});
    }

    public String selectProtocol() {
        if (this.getMembers().isEmpty()) {
            throw new IllegalStateException("Cannot select protocol for empty group");
        }
        List<String> candidates = this.candidateProtocols();
        HashMap mapValues = Maps.newHashMap();
        List<GroupMemberMetadata> allMemberMetadata = this.getAllMembers();
        for (GroupMemberMetadata memberMetadata : allMemberMetadata) {
            String protocol = memberMetadata.vote(candidates);
            Integer value = (Integer)mapValues.get(protocol);
            if (value == null) {
                mapValues.put(protocol, 1);
                continue;
            }
            Integer n = value;
            Integer n2 = value = Integer.valueOf(value + 1);
            mapValues.put(protocol, value);
        }
        String selectProtocol = null;
        int max = 0;
        for (Map.Entry entry : mapValues.entrySet()) {
            String protocol = (String)entry.getKey();
            int size = (Integer)entry.getValue();
            if (max >= size) continue;
            selectProtocol = protocol;
        }
        return selectProtocol;
    }

    private List<String> candidateProtocols() {
        List<GroupMemberMetadata> allMemberMetadata = this.getAllMembers();
        LinkedList commonProtocols = Lists.newLinkedList();
        LinkedList allMemberProtocol = Lists.newLinkedList();
        if (allMemberMetadata != null) {
            for (GroupMemberMetadata memberMetadata : allMemberMetadata) {
                Set<String> protocols = memberMetadata.protocols();
                allMemberProtocol.add(protocols);
            }
        }
        for (int i = 0; i < allMemberProtocol.size(); ++i) {
            if (i == 0) {
                commonProtocols.addAll((Collection)allMemberProtocol.get(i));
                continue;
            }
            commonProtocols.retainAll((Collection)allMemberProtocol.get(i));
        }
        return commonProtocols;
    }

    public boolean supportsProtocols(Set<String> memberProtocols) {
        HashSet result = Sets.newHashSet();
        result.addAll(memberProtocols);
        result.retainAll(this.candidateProtocols());
        return this.isMemberEmpty() || !result.isEmpty();
    }

    public boolean initNextGeneration() {
        List<GroupMemberMetadata> memberMetadataSet = this.getNotYetRejoinedMembers();
        if (CollectionUtils.isNotEmpty(memberMetadataSet)) {
            return false;
        }
        ++this.generationId;
        this.protocol = this.selectProtocol();
        this.transitionStateTo(GroupState.AWAITINGSYNC);
        return true;
    }

    public Map<String, byte[]> currentMemberMetadata() {
        if (this.stateIs(GroupState.DEAD) || this.stateIs(GroupState.PREPARINGREBALANCE)) {
            throw new IllegalStateException("Cannot obtain member metadata for group in state " + this.state.toString());
        }
        HashMap memeberMeta = Maps.newHashMap();
        for (Map.Entry entry : this.getMembers().entrySet()) {
            String memberId = (String)entry.getKey();
            GroupMemberMetadata memberMetadata = (GroupMemberMetadata)((Object)entry.getValue());
            byte[] metadata = memberMetadata.metadata(this.protocol);
            memeberMeta.put(memberId, metadata);
        }
        return memeberMeta;
    }

    private void assertValidTransition(GroupState targetState) {
        if (!ValidPreviousStates.get((Object)targetState).contains((Object)this.state)) {
            throw new IllegalStateException(String.format("Group %s should be in the %s states before moving to %s state. Instead it is in %s state", new Object[]{this.getId(), ValidPreviousStates.get((Object)targetState), targetState, this.state}));
        }
    }

    public void reset() {
        this.state = GroupState.EMPTY;
        this.leaderId = null;
        this.newMemberAdded = false;
        this.getMembers().clear();
    }

    public String toString() {
        return String.format("[%s,%s,%s,%s]", new Object[]{this.getId(), this.protocolType, this.getState(), this.getMembers()});
    }

    static {
        ValidPreviousStates.put(GroupState.EMPTY, Sets.newHashSet((Object[])new GroupState[]{GroupState.PREPARINGREBALANCE}));
        ValidPreviousStates.put(GroupState.DEAD, Sets.newHashSet((Object[])new GroupState[]{GroupState.EMPTY, GroupState.STABLE, GroupState.PREPARINGREBALANCE, GroupState.AWAITINGSYNC}));
        ValidPreviousStates.put(GroupState.AWAITINGSYNC, Sets.newHashSet((Object[])new GroupState[]{GroupState.PREPARINGREBALANCE}));
        ValidPreviousStates.put(GroupState.STABLE, Sets.newHashSet((Object[])new GroupState[]{GroupState.AWAITINGSYNC}));
        ValidPreviousStates.put(GroupState.PREPARINGREBALANCE, Sets.newHashSet((Object[])new GroupState[]{GroupState.EMPTY, GroupState.STABLE, GroupState.AWAITINGSYNC}));
    }
}

