/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import io.netty.buffer.ByteBuf;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.FindCoordinatorRequest;
import org.joyqueue.broker.kafka.command.FindCoordinatorResponse;
import org.joyqueue.broker.kafka.coordinator.CoordinatorType;
import org.joyqueue.broker.kafka.model.KafkaBroker;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;

public class FindCoordinatorCodec
implements KafkaPayloadCodec<FindCoordinatorResponse>,
Type {
    public FindCoordinatorRequest decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        FindCoordinatorRequest request = new FindCoordinatorRequest();
        request.setCoordinatorKey(Serializer.readString((ByteBuf)buffer, (int)2));
        if (header.getVersion() >= 1) {
            request.setCoordinatorType(CoordinatorType.valueOf(buffer.readByte()));
        }
        return request;
    }

    public void encode(FindCoordinatorResponse payload, ByteBuf buffer) throws Exception {
        short version = payload.getVersion();
        if (version >= 1) {
            buffer.writeInt(payload.getThrottleTimeMs());
        }
        buffer.writeShort((int)payload.getErrorCode());
        if (version >= 1) {
            Serializer.write((String)"", (ByteBuf)buffer, (int)2);
        }
        KafkaBroker broker = payload.getBroker();
        buffer.writeInt(broker.getId());
        Serializer.write((String)broker.getHost(), (ByteBuf)buffer, (int)2);
        buffer.writeInt(broker.getPort());
    }

    public int type() {
        return KafkaCommandType.FIND_COORDINATOR.getCode();
    }
}

