/**
 * Copyright 2019 The JoyQueue Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.joyqueue.broker.kafka.command;

import java.util.List;
import java.util.Map;

/**
 * SyncGroupAssignment
 *
 * author: gaohaoxiang
 * date: 2018/12/5
 */
public class SyncGroupAssignment {

    private byte[] userData;
    private Map<String, List<Integer>> topicPartitions;

    public byte[] getUserData() {
        return userData;
    }

    public void setUserData(byte[] userData) {
        this.userData = userData;
    }

    public void setTopicPartitions(Map<String, List<Integer>> topicPartitions) {
        this.topicPartitions = topicPartitions;
    }

    public Map<String, List<Integer>> getTopicPartitions() {
        return topicPartitions;
    }
}