/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.KafkaCommandHandler;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.TxnOffsetCommitRequest;
import org.joyqueue.broker.kafka.command.TxnOffsetCommitResponse;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionCoordinator;
import org.joyqueue.broker.kafka.coordinator.transaction.exception.TransactionException;
import org.joyqueue.broker.kafka.helper.KafkaClientHelper;
import org.joyqueue.broker.kafka.model.OffsetAndMetadata;
import org.joyqueue.broker.kafka.model.PartitionMetadataAndError;
import org.joyqueue.network.protocol.annotation.ProduceHandler;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProduceHandler
public class TxnOffsetCommitRequestHandler
implements KafkaCommandHandler,
Type,
KafkaContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(TxnOffsetCommitRequestHandler.class);
    private TransactionCoordinator transactionCoordinator;

    @Override
    public void setKafkaContext(KafkaContext kafkaContext) {
        this.transactionCoordinator = kafkaContext.getTransactionCoordinator();
    }

    public Command handle(Transport transport, Command command) {
        String clientId;
        TxnOffsetCommitRequest txnOffsetCommitRequest = (TxnOffsetCommitRequest)command.getPayload();
        String groupId = clientId = KafkaClientHelper.parseClient(txnOffsetCommitRequest.getClientId());
        TxnOffsetCommitResponse response = null;
        try {
            Map<String, List<PartitionMetadataAndError>> errors = this.transactionCoordinator.handleCommitOffset(clientId, txnOffsetCommitRequest.getTransactionId(), groupId, txnOffsetCommitRequest.getProducerId(), txnOffsetCommitRequest.getProducerEpoch(), txnOffsetCommitRequest.getPartitions());
            response = new TxnOffsetCommitResponse(errors);
        }
        catch (TransactionException e) {
            logger.warn("commit offset to txn exception, code: {}, message: {}, request: {}", new Object[]{e.getCode(), e.getMessage(), txnOffsetCommitRequest});
            response = new TxnOffsetCommitResponse(this.buildPartitionError(e.getCode(), txnOffsetCommitRequest.getPartitions()));
        }
        catch (Exception e) {
            logger.error("commit offset to txn exception, request: {}", (Object)txnOffsetCommitRequest, (Object)e);
            response = new TxnOffsetCommitResponse(this.buildPartitionError(KafkaErrorCode.exceptionFor(e), txnOffsetCommitRequest.getPartitions()));
        }
        return new Command((Object)response);
    }

    protected Map<String, List<PartitionMetadataAndError>> buildPartitionError(int code, Map<String, List<OffsetAndMetadata>> partitions) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)partitions.size());
        for (Map.Entry<String, List<OffsetAndMetadata>> entry : partitions.entrySet()) {
            ArrayList partitionMetadataAndErrors = Lists.newArrayListWithCapacity((int)entry.getValue().size());
            for (OffsetAndMetadata partition : entry.getValue()) {
                partitionMetadataAndErrors.add(new PartitionMetadataAndError(partition.getPartition(), (short)code));
            }
            result.put(entry.getKey(), partitionMetadataAndErrors);
        }
        return result;
    }

    public int type() {
        return KafkaCommandType.TXN_OFFSET_COMMIT.getCode();
    }
}

