/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import org.joyqueue.broker.kafka.KafkaCommandHandler;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.EndTxnRequest;
import org.joyqueue.broker.kafka.command.EndTxnResponse;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionCoordinator;
import org.joyqueue.broker.kafka.coordinator.transaction.exception.TransactionException;
import org.joyqueue.broker.kafka.helper.KafkaClientHelper;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndTxnRequestHandler
implements KafkaCommandHandler,
Type,
KafkaContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(EndTxnRequestHandler.class);
    private TransactionCoordinator transactionCoordinator;

    @Override
    public void setKafkaContext(KafkaContext kafkaContext) {
        this.transactionCoordinator = kafkaContext.getTransactionCoordinator();
    }

    public Command handle(Transport transport, Command command) {
        EndTxnRequest endTxnRequest = (EndTxnRequest)command.getPayload();
        String clientId = KafkaClientHelper.parseClient(endTxnRequest.getClientId());
        EndTxnResponse response = null;
        try {
            boolean isSuccess = this.transactionCoordinator.handleEndTxn(clientId, endTxnRequest.getTransactionId(), endTxnRequest.getProducerId(), endTxnRequest.getProducerEpoch(), endTxnRequest.isCommit());
            response = new EndTxnResponse(KafkaErrorCode.NONE.getCode());
        }
        catch (TransactionException e) {
            logger.warn("endTxn exception, message: {}, request: {}, code: {}", new Object[]{e.getMessage(), endTxnRequest, e.getCode()});
            response = new EndTxnResponse((short)e.getCode());
        }
        catch (Exception e) {
            logger.error("endTxn exception, request: {}", (Object)endTxnRequest, (Object)e);
            response = new EndTxnResponse(KafkaErrorCode.exceptionFor(e));
        }
        return new Command((Object)response);
    }

    public int type() {
        return KafkaCommandType.END_TXN.getCode();
    }
}

