/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.transaction.completion;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.joyqueue.broker.kafka.config.KafkaConfig;
import org.joyqueue.broker.kafka.coordinator.Coordinator;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionMetadataManager;
import org.joyqueue.broker.kafka.coordinator.transaction.completion.TransactionSegmentCompletionHandler;
import org.joyqueue.broker.kafka.coordinator.transaction.log.TransactionLog;
import org.joyqueue.broker.kafka.coordinator.transaction.log.TransactionLogSegment;
import org.joyqueue.broker.kafka.coordinator.transaction.synchronizer.TransactionSynchronizer;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCompletionHandler
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(TransactionCompletionHandler.class);
    private KafkaConfig config;
    private Coordinator coordinator;
    private TransactionMetadataManager transactionMetadataManager;
    private TransactionLog transactionLog;
    private TransactionSynchronizer transactionSynchronizer;
    private Map<Short, TransactionSegmentCompletionHandler> handlerMap = Maps.newHashMap();

    public TransactionCompletionHandler(KafkaConfig config, Coordinator coordinator, TransactionMetadataManager transactionMetadataManager, TransactionLog transactionLog, TransactionSynchronizer transactionSynchronizer) {
        this.config = config;
        this.coordinator = coordinator;
        this.transactionMetadataManager = transactionMetadataManager;
        this.transactionLog = transactionLog;
        this.transactionSynchronizer = transactionSynchronizer;
    }

    public void handle() {
        try {
            HashSet partitions = Sets.newHashSet(this.transactionLog.getPartitions());
            Iterator<Map.Entry<Short, TransactionSegmentCompletionHandler>> handlerIterator = this.handlerMap.entrySet().iterator();
            while (handlerIterator.hasNext()) {
                Map.Entry<Short, TransactionSegmentCompletionHandler> entry = handlerIterator.next();
                if (partitions.contains(entry.getKey())) continue;
                handlerIterator.remove();
                this.transactionLog.removeSegment(entry.getKey());
            }
            for (Short s : partitions) {
                TransactionLogSegment transactionLogSegment;
                if (this.handlerMap.containsKey(s) || (transactionLogSegment = this.transactionLog.getSegment(s)) == null) continue;
                this.handlerMap.put(s, new TransactionSegmentCompletionHandler(this.config, this.coordinator, this.transactionMetadataManager, transactionLogSegment, this.transactionSynchronizer));
            }
            for (Map.Entry entry : this.handlerMap.entrySet()) {
                ((TransactionSegmentCompletionHandler)entry.getValue()).handle();
            }
        }
        catch (Exception e) {
            logger.error("transaction compensate exception", (Throwable)e);
        }
    }
}

