/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.group;

import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.command.SyncGroupAssignment;
import org.joyqueue.broker.kafka.coordinator.Coordinator;
import org.joyqueue.broker.kafka.coordinator.group.GroupBalanceHandler;
import org.joyqueue.broker.kafka.coordinator.group.GroupMetadataManager;
import org.joyqueue.broker.kafka.coordinator.group.GroupOffsetHandler;
import org.joyqueue.broker.kafka.coordinator.group.callback.JoinCallback;
import org.joyqueue.broker.kafka.coordinator.group.callback.SyncCallback;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupDescribe;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupMetadata;
import org.joyqueue.broker.kafka.model.OffsetAndMetadata;
import org.joyqueue.broker.kafka.model.OffsetMetadataAndError;
import org.joyqueue.domain.Broker;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCoordinator
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(GroupCoordinator.class);
    private Coordinator coordinator;
    private GroupBalanceHandler groupBalanceHandler;
    private GroupOffsetHandler groupOffsetHandler;
    private GroupMetadataManager groupMetadataManager;

    public GroupCoordinator(Coordinator coordinator, GroupBalanceHandler groupBalanceHandler, GroupOffsetHandler groupOffsetHandler, GroupMetadataManager groupMetadataManager) {
        this.coordinator = coordinator;
        this.groupBalanceHandler = groupBalanceHandler;
        this.groupOffsetHandler = groupOffsetHandler;
        this.groupMetadataManager = groupMetadataManager;
    }

    public Broker findCoordinator(String groupId) {
        return this.coordinator.findGroup(groupId);
    }

    public boolean isCurrentCoordinator(String groupId) {
        return this.coordinator.isCurrentGroup(groupId);
    }

    public void handleJoinGroup(String groupId, String memberId, String clientId, String clientHost, int rebalanceTimeoutMs, int sessionTimeoutMs, String protocolType, Map<String, byte[]> protocols, JoinCallback callback) {
        this.groupBalanceHandler.joinGroup(groupId, memberId, clientId, clientHost, rebalanceTimeoutMs, sessionTimeoutMs, protocolType, protocols, callback);
    }

    public void handleSyncGroup(String groupId, int generation, String memberId, Map<String, SyncGroupAssignment> groupAssignment, SyncCallback callback) {
        this.groupBalanceHandler.syncGroup(groupId, generation, memberId, groupAssignment, callback);
    }

    public short handleLeaveGroup(String groupId, String memberId) {
        return this.groupBalanceHandler.leaveGroup(groupId, memberId);
    }

    public List<GroupDescribe> handleDescribeGroups(List<String> groupIds) {
        return this.groupBalanceHandler.describeGroups(groupIds);
    }

    public Map<String, List<OffsetMetadataAndError>> handleCommitOffsets(String groupId, String memberId, int generationId, Map<String, List<OffsetAndMetadata>> offsets) {
        return this.groupOffsetHandler.commitOffsets(groupId, memberId, generationId, offsets);
    }

    public Map<String, List<OffsetMetadataAndError>> handleFetchOffsets(String groupId, Map<String, List<Integer>> topicAndPartitions) {
        return this.groupOffsetHandler.fetchOffsets(groupId, topicAndPartitions);
    }

    public short handleHeartbeat(String groupId, String memberId, int generationId) {
        return this.groupBalanceHandler.heartbeat(groupId, memberId, generationId);
    }

    public GroupMetadata getGroup(String groupId) {
        return this.groupMetadataManager.getGroup(groupId);
    }

    public boolean removeGroup(GroupMetadata group) {
        return this.groupMetadataManager.removeGroup(group.getId());
    }

    public boolean removeGroup(String groupId) {
        return this.groupMetadataManager.removeGroup(groupId);
    }
}

