/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.maven;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jooq.tools.StringUtils;
import org.jooq.util.GenerationTool;
import org.jooq.util.maven.Generator;
import org.jooq.util.maven.Jdbc;
import org.jooq.util.maven.MasterDataTable;

public class Plugin
extends AbstractMojo {
    private MavenProject project;
    private Jdbc jdbc;
    private Generator generator;

    public void execute() throws MojoExecutionException {
        Properties props = new Properties();
        props.put("jdbc.Driver", this.jdbc.getDriver());
        props.put("jdbc.URL", this.jdbc.getUrl());
        props.put("jdbc.Schema", StringUtils.defaultString((String)this.jdbc.getSchema()));
        props.put("jdbc.User", StringUtils.defaultString((String)this.jdbc.getUser()));
        props.put("jdbc.Password", StringUtils.defaultString((String)this.jdbc.getPassword()));
        props.put("generator", StringUtils.defaultString((String)this.generator.getName()));
        props.put("generator.database", StringUtils.defaultString((String)this.generator.getDatabase().getName()));
        props.put("generator.database.includes", StringUtils.defaultString((String)this.generator.getDatabase().getIncludes()));
        props.put("generator.database.excludes", StringUtils.defaultString((String)this.generator.getDatabase().getExcludes()));
        props.put("generator.database.input-schema", StringUtils.defaultString((String)this.generator.getDatabase().getInputSchema()));
        props.put("generator.database.output-schema", StringUtils.defaultString((String)this.generator.getDatabase().getOutputSchema()));
        props.put("generator.generate.relations", StringUtils.defaultString((String)this.generator.getGenerate().getRelations()));
        props.put("generator.generate.deprecated", StringUtils.defaultString((String)this.generator.getGenerate().getDeprecated()));
        props.put("generator.generate.instance-fields", StringUtils.defaultString((String)this.generator.getGenerate().getInstanceFields()));
        props.put("generator.target.package", this.generator.getTarget().getPackageName());
        props.put("generator.target.directory", this.generator.getTarget().getDirectory());
        if (this.generator.getMasterDataTables() != null) {
            StringBuilder mdtList = new StringBuilder();
            for (MasterDataTable mdt : this.generator.getMasterDataTables()) {
                if (mdtList.length() > 0) {
                    mdtList.append(",");
                }
                mdtList.append(mdt.getName());
                props.put("generator.generate.master-data-table-literal." + mdt.getName(), mdt.getLiteral());
                props.put("generator.generate.master-data-table-description." + mdt.getName(), mdt.getDescription());
            }
            props.put("generator.generate.master-data-tables", mdtList.toString());
        }
        if (this.getLog().isDebugEnabled()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                props.store(stream, "passing these properties to jooq-codegen:");
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.getLog().debug((CharSequence)stream.toString());
        }
        try {
            GenerationTool.main((Properties)props);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error running jOOQ code generation tool", ex);
        }
        this.project.addCompileSourceRoot(this.generator.getTarget().getDirectory());
    }
}

