/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.spring.backend;

import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.AbstractRequestHandler;
import org.jolokia.server.core.service.request.RequestHandler;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.support.spring.backend.SpringCommandHandler;
import org.jolokia.support.spring.backend.SpringListHandler;
import org.jolokia.support.spring.backend.SpringReadHandler;
import org.springframework.context.ApplicationContext;

public class SpringRequestHandler
extends AbstractRequestHandler
implements RequestHandler {
    public static final String PROVIDER = "spring";
    private final ApplicationContext appContext;
    private final Map<RequestType, SpringCommandHandler<?>> commandHandlerMap = new HashMap();

    public SpringRequestHandler(ApplicationContext pAppContext, int pOrder) {
        super(PROVIDER, pOrder);
        this.appContext = pAppContext;
    }

    public <R extends JolokiaRequest> Object handleRequest(R pJmxReq, Object pPreviousResult) throws JMException {
        SpringCommandHandler<?> handler = this.commandHandlerMap.get(pJmxReq.getType());
        if (handler == null) {
            throw new UnsupportedOperationException("No spring command handler for type " + String.valueOf(pJmxReq.getType()) + " registered");
        }
        return handler.handleRequest(pJmxReq, pPreviousResult);
    }

    public void init(JolokiaContext pJolokiaContext) {
        for (SpringCommandHandler handler : new SpringCommandHandler[]{new SpringReadHandler(this.appContext, pJolokiaContext), new SpringListHandler(this.appContext, pJolokiaContext)}) {
            this.commandHandlerMap.put(handler.getType(), handler);
        }
    }

    public boolean canHandle(JolokiaRequest pJolokiaRequest) {
        return super.canHandle(pJolokiaRequest) && this.commandHandlerMap.containsKey(pJolokiaRequest.getType());
    }
}

