/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.spring.backend;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.jolokia.server.core.request.JolokiaReadRequest;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.support.spring.backend.SpringCommandHandler;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class SpringReadHandler
extends SpringCommandHandler<JolokiaReadRequest> {
    protected SpringReadHandler(ApplicationContext pAppContext, JolokiaContext pContext) {
        super(pAppContext, pContext, RequestType.READ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object handleRequest(JolokiaReadRequest pJmxReq, Object pPreviousResult) throws InstanceNotFoundException, AttributeNotFoundException {
        ObjectName oName = pJmxReq.getObjectName();
        String beanName = oName.getKeyProperty("name");
        if (beanName == null) {
            beanName = oName.getKeyProperty("id");
        }
        if (beanName == null) {
            throw new IllegalArgumentException("No bean name given with property 'name' when requesting " + oName);
        }
        ApplicationContext ctx = this.getApplicationContext();
        Object bean = ctx.getBean(beanName);
        Class<?> clazz = bean.getClass();
        String attribute = pJmxReq.getAttributeName();
        if (attribute == null) {
            throw new UnsupportedOperationException("Multi attribute read not implemented yet");
        }
        Method getter = ReflectionUtils.findMethod(clazz, (String)("get" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1)));
        if (getter != null) {
            return ReflectionUtils.invokeMethod((Method)getter, (Object)bean);
        }
        Field field = ReflectionUtils.findField(clazz, (String)attribute);
        if (field == null) throw new AttributeNotFoundException("No attribute " + attribute + " found on bean " + beanName + "(class " + clazz + ") while processing " + oName);
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        try {
            Object object = ReflectionUtils.getField((Field)field, (Object)bean);
            field.setAccessible(isAccessible);
            return object;
        }
        catch (Throwable throwable) {
            try {
                field.setAccessible(isAccessible);
                throw throwable;
            }
            catch (NoSuchBeanDefinitionException exp) {
                throw (InstanceNotFoundException)new InstanceNotFoundException("No bean with name " + beanName + " found in application context").initCause(exp);
            }
        }
    }
}

