package org.jolokia.support.jmx;

/*
 * Copyright 2009-2013 Roland Huss
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import javax.management.MBeanServer;

/**
 * Holder for a Jolokia MBeanServer
 *
 * @author roland
 * @since 13.01.13
 */
public interface JolokiaMBeanServerHolderMBean {

    /**
     * Name of MBean used for registration
     */
    String OBJECT_NAME = "jolokia:type=MBeanServer";

    /**
     * Attribute name for getting the server
     */
    String JOLOKIA_MBEAN_SERVER_ATTRIBUTE = "JolokiaMBeanServer";

    /**
     * Get the Jolokia MBeanServer
     *
     * @return Jolokia's (JSR-160 hidden) MBeanServer
     */
    MBeanServer getJolokiaMBeanServer();
}
