/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.jee;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import org.jolokia.core.util.ClassUtil;
import org.jolokia.server.core.detector.DefaultServerHandle;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.detector.jee.AbstractServerDetector;

public class WebsphereDetector
extends AbstractServerDetector {
    private static final Pattern SERVER_VERSION_PATTERN = Pattern.compile("^Version\\s+([0-9.]+)\\s*$.*?^Build Date\\s+([0-9/]+)\\s*$", 42);
    public static final String INTERNAL_ERROR_MSG = "Internal: Found AdminServiceFactory but can not call methods on it (wrong WAS version ?)";
    private final boolean isWebsphere = ClassUtil.checkForClass((String)"com.ibm.websphere.management.AdminServiceFactory");
    private final boolean isWebsphere7 = ClassUtil.checkForClass((String)"com.ibm.websphere.management.AdminContext");
    private final boolean isWebsphere6 = this.isWebsphere && !this.isWebsphere7;

    public WebsphereDetector(int pOrder) {
        super("websphere", pOrder);
    }

    public ServerHandle detect(MBeanServerAccess pMBeanServerAccess) {
        String serverVersion = this.getSingleStringAttribute(pMBeanServerAccess, "*:j2eeType=J2EEServer,type=Server,*", "serverVersion");
        if (serverVersion != null && serverVersion.contains("WebSphere")) {
            Matcher matcher = SERVER_VERSION_PATTERN.matcher(serverVersion);
            if (matcher.find()) {
                String version = matcher.group(1);
                String date = matcher.group(2);
                HashMap<String, String> extraInfo = new HashMap<String, String>();
                if (date != null) {
                    extraInfo.put("buildDate", date);
                }
                return new WebsphereServerHandle(version, !extraInfo.isEmpty() ? extraInfo : null);
            }
            return null;
        }
        if (this.isWebsphere) {
            return new WebsphereServerHandle(this.isWebsphere6 ? "6" : "7 or 8", null);
        }
        return null;
    }

    @Override
    public Set<MBeanServerConnection> getMBeanServers() {
        try {
            Method getMBeanFactoryMethod;
            Object mbeanFactory;
            Class adminServiceClass = ClassUtil.classForName((String)"com.ibm.websphere.management.AdminServiceFactory", (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()});
            if (adminServiceClass != null && (mbeanFactory = (getMBeanFactoryMethod = adminServiceClass.getMethod("getMBeanFactory", new Class[0])).invoke(null, new Object[0])) != null) {
                Method getMBeanServerMethod = mbeanFactory.getClass().getMethod("getMBeanServer", new Class[0]);
                return Collections.singleton((MBeanServerConnection)getMBeanServerMethod.invoke(mbeanFactory, new Object[0]));
            }
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(INTERNAL_ERROR_MSG, ex);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            throw new IllegalArgumentException(INTERNAL_ERROR_MSG, ex);
        }
        return null;
    }

    static class WebsphereServerHandle
    extends DefaultServerHandle {
        private final Map<String, String> extraInfo;

        public WebsphereServerHandle(String pVersion, Map<String, String> pExtrainfo) {
            super("IBM", "websphere", pVersion);
            this.extraInfo = pExtrainfo;
        }

        public Map<String, String> getExtraInfo(MBeanServerAccess pServerManager) {
            return this.extraInfo;
        }
    }
}

