/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.jee;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.management.MBeanServerConnection;
import org.jolokia.core.util.ClassUtil;
import org.jolokia.server.core.detector.DefaultServerHandle;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.detector.jee.AbstractServerDetector;

public class JBossDetector
extends AbstractServerDetector {
    public static final String JBOSS_AS_MANAGEMENT_ROOT_SERVER = "jboss.as:management-root=server";
    public static final int LOGGING_DETECT_TIMEOUT = 300000;
    public static final int LOGGING_DETECT_INTERVAL = 200;

    public JBossDetector(int pOrder) {
        super("jboss", pOrder);
    }

    public ServerHandle detect(MBeanServerAccess pMBeanServerAccess) {
        ServerHandle handle = this.checkFromJSR77(pMBeanServerAccess);
        if (handle == null) {
            handle = this.checkFor5viaJMX(pMBeanServerAccess);
            if (handle == null) {
                handle = this.checkForManagementRootServerViaJMX(pMBeanServerAccess);
            }
            if (handle == null) {
                handle = this.checkForWildflySwarm();
            }
            if (handle == null) {
                handle = this.fallbackForVersion7Check(pMBeanServerAccess);
            }
        }
        return handle;
    }

    private ServerHandle checkForWildflySwarm() {
        if (this.isJBossModulesBasedContainer(this.getClass().getClassLoader()) && System.getProperties().containsKey("swarm.app.artifact")) {
            String version = System.getProperty("swarm.version");
            return new JBossServerHandle(version != null ? version : "unknown", "Wildfly Swarm");
        }
        return null;
    }

    @Override
    public ClassLoader jvmAgentStartup(Instrumentation instrumentation) {
        this.jvmAgentStartup(instrumentation, this.getClass().getClassLoader());
        return null;
    }

    void jvmAgentStartup(Instrumentation instrumentation, ClassLoader classLoader) {
        if (this.isJBossModulesBasedContainer(classLoader)) {
            this.awaitServerInitializationForJBossModulesBasedContainer(instrumentation);
        }
    }

    protected boolean isJBossModulesBasedContainer(ClassLoader classLoader) {
        return this.hasWildflyProperties() && classLoader.getResource("org/jboss/modules/Main.class") != null;
    }

    private boolean hasWildflyProperties() {
        if (System.getProperty("jboss.modules.system.pkgs") != null) {
            return true;
        }
        String bootModuleLoader = System.getProperty("boot.module.loader");
        if (bootModuleLoader != null) {
            return bootModuleLoader.contains("wildfly");
        }
        return false;
    }

    @Override
    protected int getDetectionTimeout() {
        return 300000;
    }

    @Override
    protected int getDetectionInterval() {
        return 200;
    }

    private void awaitServerInitializationForJBossModulesBasedContainer(Instrumentation instrumentation) {
        this.activeWait(instrumentation, () -> {
            String loggingManagerClassName = System.getProperty("java.util.logging.manager");
            if (loggingManagerClassName != null && this.isClassLoaded(loggingManagerClassName, instrumentation)) {
                return true;
            }
            return false;
        }, "Detected JBoss Module loader, but property java.util.logging.manager is not set after %d seconds");
    }

    private ServerHandle checkFromJSR77(MBeanServerAccess pMBeanServerAccess) {
        String version;
        if (ClassUtil.checkForClass((String)"org.jboss.mx.util.MBeanServerLocator") && (version = this.getVersionFromJsr77(pMBeanServerAccess)) != null) {
            int idx = version.indexOf(32);
            if (idx >= 0) {
                version = version.substring(0, idx);
            }
            return new JBossServerHandle(version);
        }
        return null;
    }

    private ServerHandle checkFor5viaJMX(MBeanServerAccess pMBeanServerAccess) {
        if (this.mBeanExists(pMBeanServerAccess, "jboss.system:type=Server")) {
            String versionFull = this.getAttributeValue(pMBeanServerAccess, "jboss.system:type=Server", "Version");
            String version = null;
            if (versionFull != null) {
                version = versionFull.replaceAll("\\(.*", "").trim();
            }
            return new JBossServerHandle(version);
        }
        return null;
    }

    private ServerHandle checkForManagementRootServerViaJMX(MBeanServerAccess pMBeanServerAccess) {
        if (!this.searchMBeans(pMBeanServerAccess, "jboss.as:*").isEmpty()) {
            String version = this.getAttributeValue(pMBeanServerAccess, JBOSS_AS_MANAGEMENT_ROOT_SERVER, "productVersion");
            if (version == null) {
                version = this.getAttributeValue(pMBeanServerAccess, JBOSS_AS_MANAGEMENT_ROOT_SERVER, "releaseVersion");
            }
            if (version != null) {
                String product = this.getAttributeValue(pMBeanServerAccess, JBOSS_AS_MANAGEMENT_ROOT_SERVER, "productName");
                return new JBossServerHandle(version, product != null ? product : "jboss");
            }
        }
        return null;
    }

    private ServerHandle fallbackForVersion7Check(MBeanServerAccess pMBeanServerAccess) {
        if (this.mBeanExists(pMBeanServerAccess, "jboss.modules:*")) {
            return new JBossServerHandle("7");
        }
        return null;
    }

    @Override
    public Set<MBeanServerConnection> getMBeanServers() {
        try {
            Class<?> locatorClass = Class.forName("org.jboss.mx.util.MBeanServerLocator");
            Method method = locatorClass.getMethod("locateJBoss", new Class[0]);
            return Collections.singleton((MBeanServerConnection)method.invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static class JBossServerHandle
    extends DefaultServerHandle {
        JBossServerHandle(String version, String name) {
            super("RedHat", name, version);
        }

        JBossServerHandle(String version) {
            this(version, "jboss");
        }
    }
}

