/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.json.JSONStructure;
import org.jolokia.json.parser.JSONParser;
import org.jolokia.json.parser.ParseException;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.BaseRequestHandler;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.JolokiaRequestFactory;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.service.api.JolokiaContext;

public class HttpRequestHandler
extends BaseRequestHandler {
    private static final Pattern PATH_PREFIX_PATTERN = Pattern.compile("^/?[^/]+/");

    public HttpRequestHandler(JolokiaContext context) {
        super(context);
    }

    public JSONStructure handleGetRequest(String pUri, String pPathInfo, Map<String, String[]> pParameterMap) throws EmptyResponseException {
        String pathInfo = this.extractPathInfo(pUri, pPathInfo);
        Object jmxReq = JolokiaRequestFactory.createGetRequest(pathInfo, this.getProcessingParameter(pParameterMap));
        if (this.jolokiaCtx.isDebug()) {
            this.jolokiaCtx.debug("URI: " + pUri);
            this.jolokiaCtx.debug("Path-Info: " + pathInfo);
            this.jolokiaCtx.debug("Request: " + jmxReq.toString());
        }
        return this.executeRequest((JolokiaRequest)jmxReq);
    }

    public JSONStructure handlePostRequest(String pUri, InputStream pInputStream, String pEncoding, Map<String, String[]> pParameterMap) throws IOException, EmptyResponseException {
        if (this.jolokiaCtx.isDebug()) {
            this.jolokiaCtx.debug("URI: " + pUri);
        }
        ProcessingParameters parameters = this.getProcessingParameter(pParameterMap);
        Object jsonRequest = this.extractJsonRequest(pInputStream, pEncoding);
        if (jsonRequest instanceof JSONArray) {
            List<JolokiaRequest> jolokiaRequests = JolokiaRequestFactory.createPostRequests((List)jsonRequest, parameters);
            JSONArray responseList = new JSONArray(jolokiaRequests.size());
            for (JolokiaRequest jmxReq : jolokiaRequests) {
                if (this.jolokiaCtx.isDebug()) {
                    this.jolokiaCtx.debug("Request: " + jmxReq.toString());
                }
                JSONObject resp = this.executeRequest(jmxReq);
                responseList.add((Object)resp);
            }
            return responseList;
        }
        if (jsonRequest instanceof JSONObject) {
            Object jmxReq = JolokiaRequestFactory.createPostRequest((Map)jsonRequest, parameters);
            return this.executeRequest((JolokiaRequest)jmxReq);
        }
        throw new BadRequestException("Invalid JSON Request. Expected Object or Array");
    }

    public Map<String, String> handleCorsPreflightRequest(String pOrigin, String pRequestHeaders) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.jolokiaCtx.isOriginAllowed(pOrigin, false)) {
            ret.put("Access-Control-Allow-Origin", pOrigin == null || "null".equals(pOrigin) ? "*" : pOrigin);
            if (pRequestHeaders != null) {
                ret.put("Access-Control-Allow-Headers", pRequestHeaders);
            }
            ret.put("Access-Control-Allow-Credentials", "true");
            ret.put("Access-Control-Max-Age", "31536000");
        }
        return ret;
    }

    private Object extractJsonRequest(InputStream pInputStream, String pEncoding) throws IOException {
        try {
            InputStreamReader reader = pEncoding != null ? new InputStreamReader(pInputStream, pEncoding) : new InputStreamReader(pInputStream);
            JSONParser parser = new JSONParser();
            return parser.parse((Reader)reader);
        }
        catch (ParseException exp) {
            throw new BadRequestException("Invalid JSON request", exp);
        }
    }

    public void checkAccess(String pRequestScheme, String pHost, String pAddress, String pOrigin) {
        String[] stringArray;
        if (pHost != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = pHost;
            stringArray = stringArray2;
            stringArray2[1] = pAddress;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = pAddress;
        }
        if (!this.jolokiaCtx.isRemoteAccessAllowed(stringArray)) {
            throw new SecurityException("No access from client " + pAddress + " allowed");
        }
        if (!this.jolokiaCtx.isOriginAllowed(pOrigin, true)) {
            throw new SecurityException("Origin " + pOrigin + " is not allowed to call this agent");
        }
        if (!this.jolokiaCtx.ignoreScheme() && "http".equals(pRequestScheme) && pOrigin != null && !"null".equals(pOrigin)) {
            try {
                String originScheme = new URL(pOrigin).getProtocol();
                if ("https".equals(originScheme)) {
                    throw new SecurityException("Secure origin " + pOrigin + " should not be processed over HTTP");
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public String extractCorsOrigin(String pOrigin) {
        if (pOrigin != null) {
            String origin = pOrigin.replaceAll("[\\n\\r]*", "");
            if (this.jolokiaCtx.isOriginAllowed(origin, false)) {
                return "null".equals(origin) ? "*" : origin;
            }
            return null;
        }
        return null;
    }

    private String extractPathInfo(String pUri, String pPathInfo) {
        Matcher matcher;
        if (pUri.contains("!//") && (matcher = PATH_PREFIX_PATTERN.matcher(pPathInfo)).find()) {
            String prefix = matcher.group();
            String pathInfoEncoded = pUri.replaceFirst("^.*?" + prefix, prefix);
            return URLDecoder.decode(pathInfoEncoded, StandardCharsets.UTF_8);
        }
        return pPathInfo;
    }
}

