/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jolokia.server.core.util.jmx.JmxUtil;
import org.jolokia.server.core.util.jmx.MBeanServerDumper;

public class MBeanServers
implements NotificationListener {
    private final Set<MBeanServerConnection> detectedMBeanServers = new LinkedHashSet<MBeanServerConnection>();
    private final Set<MBeanServerConnection> allMBeanServers;
    private final NotificationListener jolokiaMBeanServerListener;
    private MBeanServerConnection jolokiaMBeanServer;
    private static final ObjectName JOLOKIA_MBEAN_SERVER_ONAME = JmxUtil.newObjectName("jolokia:type=MBeanServer");

    MBeanServers(Set<MBeanServerConnection> pExtraServers, NotificationListener pListener) {
        this.jolokiaMBeanServerListener = pListener;
        this.jolokiaMBeanServer = this.lookupJolokiaMBeanServer();
        this.addJolokiaMBeanServerRegistrationListener();
        if (pExtraServers != null) {
            this.detectedMBeanServers.addAll(pExtraServers);
        }
        ArrayList<MBeanServer> beanServers = MBeanServerFactory.findMBeanServer(null);
        this.detectedMBeanServers.addAll(beanServers);
        this.detectedMBeanServers.add(ManagementFactory.getPlatformMBeanServer());
        this.allMBeanServers = new LinkedHashSet<MBeanServerConnection>();
        if (this.jolokiaMBeanServer != null) {
            this.allMBeanServers.add(this.jolokiaMBeanServer);
        }
        this.allMBeanServers.addAll(this.detectedMBeanServers);
    }

    @Override
    public synchronized void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if ("JMX.mbean.registered".equals(type)) {
            this.jolokiaMBeanServer = this.lookupJolokiaMBeanServer();
            if (this.jolokiaMBeanServerListener != null) {
                JmxUtil.addMBeanRegistrationListener(this.jolokiaMBeanServer, this.jolokiaMBeanServerListener, null);
            }
        } else if ("JMX.mbean.unregistered".equals(type)) {
            this.jolokiaMBeanServer = null;
        }
        this.allMBeanServers.clear();
        if (this.jolokiaMBeanServer != null) {
            this.allMBeanServers.add(this.jolokiaMBeanServer);
        }
        this.allMBeanServers.addAll(this.detectedMBeanServers);
    }

    public Set<MBeanServerConnection> getMBeanServers() {
        return this.allMBeanServers;
    }

    public String dump() {
        return MBeanServerDumper.dump(this.allMBeanServers);
    }

    public void destroy() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        JmxUtil.removeMBeanRegistrationListener(server, this);
    }

    public MBeanServerConnection getJolokiaMBeanServer() {
        return this.jolokiaMBeanServer;
    }

    private MBeanServer lookupJolokiaMBeanServer() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            return server.isRegistered(JOLOKIA_MBEAN_SERVER_ONAME) ? (MBeanServer)server.getAttribute(JOLOKIA_MBEAN_SERVER_ONAME, "JolokiaMBeanServer") : null;
        }
        catch (JMException e) {
            throw new IllegalStateException("Internal: Cannot get Jolokia MBeanServer via JMX lookup: " + e, e);
        }
    }

    private void addJolokiaMBeanServerRegistrationListener() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        JmxUtil.addMBeanRegistrationListener(server, this, JOLOKIA_MBEAN_SERVER_ONAME);
    }
}

