/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.roo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.process.manager.FileManager;
import org.springframework.roo.process.manager.MutableFile;
import org.springframework.roo.project.Dependency;
import org.springframework.roo.project.Path;
import org.springframework.roo.project.PathResolver;
import org.springframework.roo.project.ProjectMetadata;
import org.springframework.roo.project.ProjectOperations;
import org.springframework.roo.project.Repository;
import org.springframework.roo.project.maven.Pom;
import org.springframework.roo.shell.CliAvailabilityIndicator;
import org.springframework.roo.shell.CliCommand;
import org.springframework.roo.shell.CliOption;
import org.springframework.roo.shell.CommandMarker;
import org.springframework.roo.support.util.FileUtils;
import org.springframework.roo.support.util.WebXmlUtils;
import org.springframework.roo.support.util.XmlElementBuilder;
import org.springframework.roo.support.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service
public class JolokiaCommands
implements CommandMarker {
    @Reference
    private ProjectOperations projectOperations;
    @Reference
    private FileManager fileManager;
    @Reference
    private PathResolver pathResolver;
    @Reference
    private MetadataService metadataService;

    @CliAvailabilityIndicator(value={"jolokia setup"})
    public boolean isJolokiaAvailable() {
        String module = this.projectOperations.getFocusedModuleName();
        ProjectMetadata project = (ProjectMetadata)this.metadataService.get(ProjectMetadata.getProjectIdentifier((String)module));
        if (project == null) {
            return false;
        }
        return this.fileManager.exists(this.pathResolver.getIdentifier(Path.SRC_MAIN_WEBAPP.getModulePathId(module), "/WEB-INF/web.xml"));
    }

    @CliCommand(value={"jolokia setup"}, help="Adds/Updates dependencies and a servlet \"/jolokia\" for accessing the Jolokia agent")
    public void setupJolokia(@CliOption(key={"addPolicy"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Add a sample access policy descriptor") String addPolicyDescriptor, @CliOption(key={"addJsr60Proxy"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Setup agent for handling JSR-160 proxy requests") String addJsr160Proxy, @CliOption(key={"addDefaultInitParams"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Add init parameters with the default values for the Jolokia-Servlet") String addDefaultInitParams) {
        Element configuration = XmlUtils.getConfiguration(this.getClass());
        this.updateDependencies(configuration, Boolean.parseBoolean(addJsr160Proxy));
        this.addRepository(configuration);
        this.updateWebXml(configuration, Boolean.parseBoolean(addJsr160Proxy), Boolean.parseBoolean(addDefaultInitParams));
        if (Boolean.parseBoolean(addPolicyDescriptor)) {
            this.updateJolokiaAccessXml();
        }
    }

    private void updateDependencies(Element configuration, boolean pAddJsr160Proxy) {
        List dependencyElements = XmlUtils.findElements((String)"/configuration/jolokia/dependencies/dependency", (Element)configuration);
        this.addJsr160Dependencies(configuration, dependencyElements, pAddJsr160Proxy);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Element dependencyElement : dependencyElements) {
            dependencies.add(new Dependency(dependencyElement));
        }
        this.projectOperations.addDependencies(this.projectOperations.getFocusedModuleName(), dependencies);
    }

    private void addJsr160Dependencies(Element configuration, List<Element> pDependencyElements, boolean pAddJsr160Proxy) {
        List pJsr160DepElements = XmlUtils.findElements((String)"/configuration/jolokia/jsr160Proxy/dependency", (Element)configuration);
        if (pAddJsr160Proxy) {
            pDependencyElements.addAll(pJsr160DepElements);
        } else {
            Pom pom = this.projectOperations.getFocusedModule();
            for (Element jsr160DepElement : pJsr160DepElements) {
                Dependency jsr160Dep = new Dependency(jsr160DepElement);
                for (Dependency dep : pom.getDependencies()) {
                    if (!dep.hasSameCoordinates(jsr160Dep)) continue;
                    pDependencyElements.add(jsr160DepElement);
                }
            }
        }
    }

    private void addRepository(Element configuration) {
        Pom pom = this.projectOperations.getFocusedModule();
        List versions = XmlUtils.findElements((String)"/configuration/jolokia/dependencies/dependency/version", (Element)configuration);
        boolean isSnapshot = false;
        for (Element version : versions) {
            if (!version.getTextContent().matches(".*SNAPSHOT$")) continue;
            isSnapshot = true;
            break;
        }
        List repositories = isSnapshot ? XmlUtils.findElements((String)"/configuration/jolokia/snapshots-repositories/repository", (Element)configuration) : XmlUtils.findElements((String)"/configuration/jolokia/repositories/repository", (Element)configuration);
        for (Element repositoryElement : repositories) {
            Repository repository = new Repository(repositoryElement);
            this.projectOperations.addRepository(pom.getModuleName(), repository);
        }
    }

    private void updateWebXml(Element pConfiguration, boolean pAddjsr160proxy, boolean pAdddefaultinitparams) {
        block12: {
            InputStream is = null;
            try {
                String webXml = this.pathResolver.getIdentifier(Path.SRC_MAIN_WEBAPP.getModulePathId(this.projectOperations.getFocusedModuleName()), "WEB-INF/web.xml");
                if (this.fileManager.exists(webXml)) {
                    MutableFile mutableWebXml = this.fileManager.updateFile(webXml);
                    is = mutableWebXml.getInputStream();
                    Document webXmlDoc = XmlUtils.getDocumentBuilder().parse(is);
                    this.updateServletDefinition(pConfiguration, pAdddefaultinitparams, webXmlDoc);
                    if (pAddjsr160proxy) {
                        this.updateJsr160Proxy(pConfiguration, webXmlDoc);
                    }
                    XmlUtils.writeXml((OutputStream)mutableWebXml.getOutputStream(), (Document)webXmlDoc);
                    break block12;
                }
                throw new IllegalStateException("Could not acquire " + webXml);
            }
            catch (Exception exp) {
                throw new IllegalStateException(exp);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void updateServletDefinition(Element pConfiguration, boolean pAddDefaultInitParams, Document webXmlDoc) {
        WebXmlUtils.WebXmlParam[] initParams = new WebXmlUtils.WebXmlParam[]{};
        if (pAddDefaultInitParams) {
            initParams = this.getDefaultParams(pConfiguration);
        }
        WebXmlUtils.addServlet((String)"jolokia", (String)"org.jolokia.http.AgentServlet", (String)"/jolokia/*", (Integer)10, (Document)webXmlDoc, (String)"Jolokia Agent", (WebXmlUtils.WebXmlParam[])initParams);
    }

    private WebXmlUtils.WebXmlParam[] getDefaultParams(Element configuration) {
        List initParams = XmlUtils.findElements((String)"/configuration/jolokia/initParams/init-param", (Element)configuration);
        ArrayList<WebXmlUtils.WebXmlParam> ret = new ArrayList<WebXmlUtils.WebXmlParam>();
        for (Element initParam : initParams) {
            ret.add(new WebXmlUtils.WebXmlParam(this.getTextContent(initParam, "param-name"), this.getTextContent(initParam, "param-value")));
        }
        return ret.toArray(new WebXmlUtils.WebXmlParam[ret.size()]);
    }

    private void updateJolokiaAccessXml() {
        String destination = this.pathResolver.getIdentifier(Path.SRC_MAIN_RESOURCES.getModulePathId(this.projectOperations.getFocusedModuleName()), "jolokia-access.xml");
        if (!this.fileManager.exists(destination)) {
            try {
                IOUtils.copy((InputStream)FileUtils.getInputStream(this.getClass(), (String)"jolokia-access.xml"), (OutputStream)this.fileManager.createFile(destination).getOutputStream());
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }
    }

    private void updateJsr160Proxy(Element configuration, Document webXmlDoc) {
        String paramName = this.getJsr160InitArg(configuration, "param-name");
        String paramValue = this.getJsr160InitArg(configuration, "param-value");
        Element servlet = XmlUtils.findFirstElement((String)"/web-app/servlet[servlet-name = 'jolokia']", (Node)webXmlDoc.getDocumentElement());
        if (servlet == null) {
            throw new IllegalArgumentException("Internal: No servlet 'jolokia' found in WEB-INF/web.xml");
        }
        Element initParam = XmlUtils.findFirstElement((String)("init-param[param-name = '" + paramName + "']"), (Node)servlet);
        if (initParam == null) {
            initParam = new XmlElementBuilder("init-param", webXmlDoc).addChild((Node)new XmlElementBuilder("param-name", webXmlDoc).setText(paramName).build()).addChild((Node)new XmlElementBuilder("param-value", webXmlDoc).setText(paramValue).build()).build();
            Element lastElement = XmlUtils.findFirstElement((String)"load-on-startup", (Node)servlet);
            if (lastElement != null) {
                servlet.insertBefore(initParam, lastElement);
            } else {
                servlet.appendChild(initParam);
            }
        } else {
            Element value = XmlUtils.findFirstElement((String)"param-value", (Node)initParam);
            value.setTextContent(paramValue);
        }
    }

    private String getJsr160InitArg(Element configuration, String pWhat) {
        return XmlUtils.findFirstElement((String)("/configuration/jolokia/jsr160Proxy/init-param/" + pWhat), (Node)configuration).getTextContent();
    }

    private void addLineBreak(Node pRootElement, Node pBeforeThis, Document pWebXmlDoc) {
        pRootElement.insertBefore(pWebXmlDoc.createTextNode("\n    "), pBeforeThis);
        pRootElement.insertBefore(pWebXmlDoc.createTextNode("\n    "), pBeforeThis);
    }

    private String getTextContent(Element initParam, String tag) {
        return initParam.getElementsByTagName(tag).item(0).getTextContent();
    }

    protected void bindProjectOperations(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
    }

    protected void unbindProjectOperations(ProjectOperations projectOperations) {
        if (this.projectOperations == projectOperations) {
            this.projectOperations = null;
        }
    }

    protected void bindFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    protected void unbindFileManager(FileManager fileManager) {
        if (this.fileManager == fileManager) {
            this.fileManager = null;
        }
    }

    protected void bindPathResolver(PathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    protected void unbindPathResolver(PathResolver pathResolver) {
        if (this.pathResolver == pathResolver) {
            this.pathResolver = null;
        }
    }

    protected void bindMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    protected void unbindMetadataService(MetadataService metadataService) {
        if (this.metadataService == metadataService) {
            this.metadataService = null;
        }
    }
}

