/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.handler;

import java.io.IOException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import org.jolokia.Version;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.detector.ServerHandle;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.request.JmxVersionRequest;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.RequestType;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionHandler
extends JsonRequestHandler<JmxVersionRequest> {
    private final Configuration config;
    private ServerHandle serverHandle;

    public VersionHandler(Configuration pConfig, Restrictor pRestrictor, ServerHandle pServerHandle) {
        super(pRestrictor);
        this.serverHandle = pServerHandle;
        this.config = pConfig;
    }

    @Override
    public RequestType getType() {
        return RequestType.VERSION;
    }

    @Override
    protected void checkForRestriction(JmxVersionRequest pRequest) {
        this.checkType();
    }

    @Override
    public boolean handleAllServersAtOnce(JmxVersionRequest pRequest) {
        return true;
    }

    @Override
    public Object doHandleRequest(MBeanServerExecutor serverManager, JmxVersionRequest request) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        JSONObject ret = new JSONObject();
        ret.put("agent", Version.getAgentVersion());
        ret.put("protocol", Version.getProtocolVersion());
        if (this.serverHandle != null) {
            ret.put("info", this.serverHandle.toJSONObject(serverManager));
        }
        ret.put("config", this.configToJSONObject());
        return ret;
    }

    private JSONObject configToJSONObject() {
        JSONObject info = new JSONObject();
        if (this.config != null) {
            for (ConfigKey key : ConfigKey.values()) {
                String value;
                if (!key.isGlobalConfig() || (value = this.config.get(key)) == null) continue;
                info.put(key.getKeyValue(), value);
            }
        }
        return info;
    }

    @Override
    public Object doHandleRequest(MBeanServerConnection server, JmxVersionRequest request) {
        throw new UnsupportedOperationException("Internal: Method must not be called when all MBeanServers are handled at once");
    }
}

