/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.backend;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.jolokia.backend.LocalRequestDispatcher;
import org.jolokia.backend.RequestDispatcher;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.converter.Converters;
import org.jolokia.converter.json.JsonConvertOptions;
import org.jolokia.detector.ServerHandle;
import org.jolokia.history.HistoryStore;
import org.jolokia.request.JmxRequest;
import org.jolokia.restrictor.AllowAllRestrictor;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.DebugStore;
import org.jolokia.util.LogHandler;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendManager {
    private LocalRequestDispatcher localDispatcher;
    private Converters converters;
    private JsonConvertOptions.Builder convertOptionsBuilder;
    private Restrictor restrictor;
    private HistoryStore historyStore;
    private DebugStore debugStore;
    private LogHandler logHandler;
    private List<RequestDispatcher> requestDispatchers;
    private volatile Initializer initializer;

    public BackendManager(Configuration pConfig, LogHandler pLogHandler) {
        this(pConfig, pLogHandler, null);
    }

    public BackendManager(Configuration pConfig, LogHandler pLogHandler, Restrictor pRestrictor) {
        this(pConfig, pLogHandler, pRestrictor, false);
    }

    public BackendManager(Configuration pConfig, LogHandler pLogHandler, Restrictor pRestrictor, boolean pLazy) {
        this.restrictor = pRestrictor != null ? pRestrictor : new AllowAllRestrictor();
        this.logHandler = pLogHandler;
        if (pLazy) {
            this.initializer = new Initializer(pConfig);
        } else {
            this.init(pConfig);
            this.initializer = null;
        }
    }

    public JSONObject handleRequest(JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        this.lazyInitIfNeeded();
        boolean debug = this.isDebug();
        long time = 0L;
        if (debug) {
            time = System.currentTimeMillis();
        }
        JSONObject json = this.callRequestDispatcher(pJmxReq);
        this.historyStore.updateAndAdd(pJmxReq, json);
        json.put("status", 200);
        if (debug) {
            this.debug("Execution time: " + (System.currentTimeMillis() - time) + " ms");
            this.debug("Response: " + json);
        }
        return json;
    }

    public Object convertExceptionToJson(Throwable pExp, JmxRequest pJmxReq) {
        JsonConvertOptions opts = this.getJsonConvertOptions(pJmxReq);
        try {
            JSONObject expObj = (JSONObject)this.converters.getToJsonConverter().convertToJson(pExp, null, opts);
            return expObj;
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
    }

    public void destroy() {
        try {
            this.localDispatcher.destroy();
        }
        catch (JMException e) {
            this.error("Cannot unregister MBean: " + e, e);
        }
    }

    public boolean isRemoteAccessAllowed(String pRemoteHost, String pRemoteAddr) {
        return this.restrictor.isRemoteAccessAllowed(pRemoteHost, pRemoteAddr);
    }

    public boolean isCorsAccessAllowed(String pOrigin) {
        return this.restrictor.isCorsAccessAllowed(pOrigin);
    }

    public void info(String msg) {
        this.logHandler.info(msg);
        if (this.debugStore != null) {
            this.debugStore.log(msg);
        }
    }

    public void debug(String msg) {
        this.logHandler.debug(msg);
        if (this.debugStore != null) {
            this.debugStore.log(msg);
        }
    }

    public void error(String message, Throwable t) {
        this.logHandler.error(message, t);
        if (this.debugStore != null) {
            this.debugStore.log(message, t);
        }
    }

    public boolean isDebug() {
        return this.debugStore != null && this.debugStore.isDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitIfNeeded() {
        if (this.initializer != null) {
            BackendManager backendManager = this;
            synchronized (backendManager) {
                if (this.initializer != null) {
                    this.initializer.init();
                    this.initializer = null;
                }
            }
        }
    }

    private void init(Configuration pConfig) {
        this.converters = new Converters();
        this.initLimits(pConfig);
        this.localDispatcher = new LocalRequestDispatcher(this.converters, this.restrictor, pConfig, this.logHandler);
        ServerHandle serverHandle = this.localDispatcher.getServerInfo();
        this.requestDispatchers = this.createRequestDispatchers(pConfig.get(ConfigKey.DISPATCHER_CLASSES), this.converters, serverHandle, this.restrictor);
        this.requestDispatchers.add(this.localDispatcher);
        this.initStores(pConfig);
    }

    private void initLimits(Configuration pConfig) {
        this.convertOptionsBuilder = pConfig != null ? new JsonConvertOptions.Builder(this.getNullSaveIntLimit(pConfig.get(ConfigKey.MAX_DEPTH)), this.getNullSaveIntLimit(pConfig.get(ConfigKey.MAX_COLLECTION_SIZE)), this.getNullSaveIntLimit(pConfig.get(ConfigKey.MAX_OBJECTS))) : new JsonConvertOptions.Builder();
    }

    private int getNullSaveIntLimit(String pValue) {
        return pValue != null ? Integer.parseInt(pValue) : 0;
    }

    private List<RequestDispatcher> createRequestDispatchers(String pClasses, Converters pConverters, ServerHandle pServerHandle, Restrictor pRestrictor) {
        ArrayList<RequestDispatcher> ret = new ArrayList<RequestDispatcher>();
        if (pClasses != null && pClasses.length() > 0) {
            String[] names;
            for (String name : names = pClasses.split("\\s*,\\s*")) {
                ret.add(this.createDispatcher(name, pConverters, pServerHandle, pRestrictor));
            }
        }
        return ret;
    }

    private RequestDispatcher createDispatcher(String pDispatcherClass, Converters pConverters, ServerHandle pServerHandle, Restrictor pRestrictor) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(pDispatcherClass);
            Constructor<?> constructor = clazz.getConstructor(Converters.class, ServerHandle.class, Restrictor.class);
            return (RequestDispatcher)constructor.newInstance(pConverters, pServerHandle, pRestrictor);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Couldn't load class " + pDispatcherClass + ": " + e, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + pDispatcherClass + " has invalid constructor: " + e, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Constructor of " + pDispatcherClass + " couldn't be accessed: " + e, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(pDispatcherClass + " couldn't be instantiated: " + e, e);
        }
    }

    private JSONObject callRequestDispatcher(JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        Object retValue = null;
        boolean useValueWithPath = false;
        boolean found = false;
        for (RequestDispatcher dispatcher : this.requestDispatchers) {
            if (!dispatcher.canHandle(pJmxReq)) continue;
            retValue = dispatcher.dispatchRequest(pJmxReq);
            useValueWithPath = dispatcher.useReturnValueWithPath(pJmxReq);
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Internal error: No dispatcher found for handling " + pJmxReq);
        }
        JsonConvertOptions opts = this.getJsonConvertOptions(pJmxReq);
        Object jsonResult = this.converters.getToJsonConverter().convertToJson(retValue, useValueWithPath ? pJmxReq.getPathParts() : null, opts);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", jsonResult);
        jsonObject.put("request", pJmxReq.toJSON());
        return jsonObject;
    }

    private JsonConvertOptions getJsonConvertOptions(JmxRequest pJmxReq) {
        return this.convertOptionsBuilder.maxDepth(pJmxReq.getParameterAsInt(ConfigKey.MAX_DEPTH)).maxCollectionSize(pJmxReq.getParameterAsInt(ConfigKey.MAX_COLLECTION_SIZE)).maxObjects(pJmxReq.getParameterAsInt(ConfigKey.MAX_OBJECTS)).faultHandler(pJmxReq.getValueFaultHandler()).build();
    }

    private void initStores(Configuration pConfig) {
        int maxEntries = pConfig.getAsInt(ConfigKey.HISTORY_MAX_ENTRIES);
        int maxDebugEntries = pConfig.getAsInt(ConfigKey.DEBUG_MAX_ENTRIES);
        this.historyStore = new HistoryStore(maxEntries);
        this.debugStore = new DebugStore(maxDebugEntries, pConfig.getAsBoolean(ConfigKey.DEBUG));
        try {
            this.localDispatcher.initMBeans(this.historyStore, this.debugStore);
        }
        catch (NotCompliantMBeanException e) {
            this.intError("Error registering config MBean: " + e, e);
        }
        catch (MBeanRegistrationException e) {
            this.intError("Cannot register MBean: " + e, e);
        }
        catch (MalformedObjectNameException e) {
            this.intError("Invalid name for config MBean: " + e, e);
        }
    }

    private void intError(String message, Throwable t) {
        this.logHandler.error(message, t);
        this.debugStore.log(message, t);
    }

    private final class Initializer {
        private Configuration config;

        private Initializer(Configuration pConfig) {
            this.config = pConfig;
        }

        void init() {
            BackendManager.this.init(this.config);
        }
    }
}

