/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.request;

import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.request.JmxRequest;
import org.jolokia.util.ConfigKey;
import org.jolokia.util.RequestType;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JmxObjectNameRequest
extends JmxRequest {
    private ObjectName objectName;

    public JmxObjectNameRequest(RequestType pType, String pObjectName, List<String> pPathParts, Map<String, String> pProcessingParams) throws MalformedObjectNameException {
        super(pType, pPathParts, pProcessingParams);
        this.initObjectName(pObjectName);
    }

    public JmxObjectNameRequest(Map<String, ?> pRequestMap, Map<String, String> pParams) throws MalformedObjectNameException {
        super(pRequestMap, pParams);
        this.initObjectName((String)pRequestMap.get("mbean"));
    }

    @Override
    public JSONObject toJSON() {
        JSONObject ret = super.toJSON();
        ret.put("mbean", this.getOrderedObjectName(this.objectName));
        return ret;
    }

    @Override
    protected String getInfo() {
        StringBuffer ret = new StringBuffer("objectName = ").append(this.objectName.getCanonicalName());
        String baseInfo = super.getInfo();
        if (baseInfo != null) {
            ret.append(", ").append(baseInfo);
        }
        return ret.toString();
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getObjectNameAsString() {
        return this.objectName.getCanonicalName();
    }

    public String getOrderedObjectName(ObjectName pName) {
        if (pName.isPattern()) {
            return pName.getCanonicalName();
        }
        if (this.getProcessingConfigAsBoolean(ConfigKey.CANONICAL_NAMING).booleanValue()) {
            return pName.getCanonicalName();
        }
        return pName.getDomain() + ":" + pName.getKeyPropertyListString();
    }

    private void initObjectName(String pObjectName) throws MalformedObjectNameException {
        if (pObjectName == null) {
            throw new IllegalArgumentException("Objectname can not be null");
        }
        this.objectName = new ObjectName(pObjectName);
    }
}

