/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import org.jolokia.backend.BackendManager;
import org.jolokia.request.JmxRequest;
import org.jolokia.request.JmxRequestFactory;
import org.jolokia.util.LogHandler;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestHandler {
    private BackendManager backendManager;
    private LogHandler logHandler;

    public HttpRequestHandler(BackendManager pBackendManager, LogHandler pLogHandler) {
        this.backendManager = pBackendManager;
        this.logHandler = pLogHandler;
    }

    public JSONAware handleGetRequest(String pUri, String pPathInfo, Map<String, String[]> pParameterMap) {
        Object jmxReq = JmxRequestFactory.createGetRequest(pPathInfo, pParameterMap);
        if (this.backendManager.isDebug()) {
            this.logHandler.debug("URI: " + pUri);
            this.logHandler.debug("Path-Info: " + pPathInfo);
            this.logHandler.debug("Request: " + jmxReq.toString());
        }
        return this.executeRequest((JmxRequest)jmxReq);
    }

    public JSONAware handlePostRequest(String pUri, InputStream pInputStream, String pEncoding, Map<String, String[]> pParameterMap) throws IOException {
        Object jsonRequest;
        if (this.backendManager.isDebug()) {
            this.logHandler.debug("URI: " + pUri);
        }
        if ((jsonRequest = this.extractJsonRequest(pInputStream, pEncoding)) instanceof JSONArray) {
            List<JmxRequest> jmxRequests = JmxRequestFactory.createPostRequests((List)jsonRequest, pParameterMap);
            JSONArray responseList = new JSONArray();
            for (JmxRequest jmxReq : jmxRequests) {
                if (this.backendManager.isDebug()) {
                    this.logHandler.debug("Request: " + jmxReq.toString());
                }
                JSONObject resp = this.executeRequest(jmxReq);
                responseList.add(resp);
            }
            return responseList;
        }
        if (jsonRequest instanceof JSONObject) {
            Object jmxReq = JmxRequestFactory.createPostRequest((Map)jsonRequest, pParameterMap);
            return this.executeRequest((JmxRequest)jmxReq);
        }
        throw new IllegalArgumentException("Invalid JSON Request " + jsonRequest);
    }

    public Map<String, String> handleCorsPreflightRequest(String pOrigin, String pRequestHeaders) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (pOrigin != null && this.backendManager.isCorsAccessAllowed(pOrigin)) {
            ret.put("Access-Control-Allow-Origin", "null".equals(pOrigin) ? "*" : pOrigin);
            if (pRequestHeaders != null) {
                ret.put("Access-Control-Allow-Headers", pRequestHeaders);
            }
            ret.put("Access-Control-Allow-Max-Age", "31536000");
        }
        return ret;
    }

    private Object extractJsonRequest(InputStream pInputStream, String pEncoding) throws IOException {
        InputStreamReader reader = null;
        try {
            reader = pEncoding != null ? new InputStreamReader(pInputStream, pEncoding) : new InputStreamReader(pInputStream);
            JSONParser parser = new JSONParser();
            return parser.parse(reader);
        }
        catch (ParseException exp) {
            throw new IllegalArgumentException("Invalid JSON request " + reader, exp);
        }
    }

    private JSONObject executeRequest(JmxRequest pJmxReq) {
        try {
            return this.backendManager.handleRequest(pJmxReq);
        }
        catch (ReflectionException e) {
            return this.getErrorJSON(404, e, pJmxReq);
        }
        catch (InstanceNotFoundException e) {
            return this.getErrorJSON(404, e, pJmxReq);
        }
        catch (MBeanException e) {
            return this.getErrorJSON(500, e.getTargetException(), pJmxReq);
        }
        catch (AttributeNotFoundException e) {
            return this.getErrorJSON(404, e, pJmxReq);
        }
        catch (UnsupportedOperationException e) {
            return this.getErrorJSON(500, e, pJmxReq);
        }
        catch (IOException e) {
            return this.getErrorJSON(500, e, pJmxReq);
        }
        catch (IllegalArgumentException e) {
            return this.getErrorJSON(400, e, pJmxReq);
        }
        catch (SecurityException e) {
            return this.getErrorJSON(403, new Exception(e.getMessage()), pJmxReq);
        }
        catch (RuntimeMBeanException e) {
            return this.errorForUnwrappedException(e, pJmxReq);
        }
    }

    public JSONObject handleThrowable(Throwable pThrowable) {
        if (pThrowable instanceof IllegalArgumentException) {
            return this.getErrorJSON(400, pThrowable, null);
        }
        if (pThrowable instanceof SecurityException) {
            return this.getErrorJSON(403, new Exception(pThrowable.getMessage()), null);
        }
        return this.getErrorJSON(500, pThrowable, null);
    }

    public JSONObject getErrorJSON(int pErrorCode, Throwable pExp, JmxRequest pJmxReq) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("status", pErrorCode);
        jsonObject.put("error", this.getExceptionMessage(pExp));
        jsonObject.put("error_type", pExp.getClass().getName());
        StringWriter writer = new StringWriter();
        pExp.printStackTrace(new PrintWriter(writer));
        jsonObject.put("stacktrace", writer.toString());
        if (this.backendManager.isDebug()) {
            this.backendManager.error("Error " + pErrorCode, pExp);
        }
        if (pJmxReq != null) {
            jsonObject.put("request", pJmxReq.toJSON());
        }
        return jsonObject;
    }

    public void checkClientIPAccess(String pHost, String pAddress) {
        if (!this.backendManager.isRemoteAccessAllowed(pHost, pAddress)) {
            throw new SecurityException("No access from client " + pAddress + " allowed");
        }
    }

    public String extractCorsOrigin(String pOrigin) {
        if (pOrigin != null) {
            String origin = pOrigin.replaceAll("[\\n\\r]*", "");
            if (this.backendManager.isCorsAccessAllowed(origin)) {
                return "null".equals(origin) ? "*" : origin;
            }
            return null;
        }
        return null;
    }

    private String getExceptionMessage(Throwable pException) {
        String message = pException.getLocalizedMessage();
        return pException.getClass().getName() + (message != null ? " : " + message : "");
    }

    private JSONObject errorForUnwrappedException(Exception e, JmxRequest pJmxReq) {
        Throwable cause = e.getCause();
        int code = cause instanceof IllegalArgumentException ? 400 : (cause instanceof SecurityException ? 403 : 500);
        return this.getErrorJSON(code, cause, pJmxReq);
    }
}

