/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;
import org.jolokia.request.JmxObjectNameRequest;
import org.jolokia.request.JmxRequest;
import org.jolokia.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossDetector
extends AbstractServerDetector {
    @Override
    public ServerHandle detect(Set<MBeanServer> pMbeanServers) {
        String version;
        if (ClassUtil.checkForClass("org.jboss.mx.util.MBeanServerLocator") && (version = this.getVersionFromJsr77(pMbeanServers)) != null) {
            int idx = version.indexOf(32);
            if (idx >= 0) {
                version = version.substring(0, idx);
            }
            return new JBossServerHandle(version, null, null, true);
        }
        if (this.mBeanExists(pMbeanServers, "jboss.system:type=Server")) {
            String versionFull = this.getAttributeValue(pMbeanServers, "jboss.system:type=Server", "Version");
            String version2 = null;
            if (versionFull != null) {
                version2 = versionFull.replaceAll("\\(.*", "").trim();
            }
            return new JBossServerHandle(version2, null, null, true);
        }
        version = this.getSingleStringAttribute(pMbeanServers, "jboss.as:management-root=server", "releaseVersion");
        if (version != null) {
            return new JBossServerHandle(version, null, null, false);
        }
        if (this.mBeanExists(pMbeanServers, "jboss.modules:*")) {
            return new JBossServerHandle("7", null, null, false);
        }
        return null;
    }

    @Override
    public void addMBeanServers(Set<MBeanServer> servers) {
        try {
            Class<?> locatorClass = Class.forName("org.jboss.mx.util.MBeanServerLocator");
            Method method = locatorClass.getMethod("locateJBoss", new Class[0]);
            servers.add((MBeanServer)method.invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JBossServerHandle
    extends ServerHandle {
        private boolean workaroundRequired = true;

        JBossServerHandle(String version, URL agentUrl, Map<String, String> extraInfo, boolean pWorkaroundRequired) {
            super("RedHat", "jboss", version, agentUrl, extraInfo);
            this.workaroundRequired = pWorkaroundRequired;
        }

        @Override
        public void preDispatch(Set<MBeanServer> pMBeanServers, JmxRequest pJmxReq) {
            if (this.workaroundRequired && pJmxReq instanceof JmxObjectNameRequest) {
                this.workaroundForMXBeans(pMBeanServers, (JmxObjectNameRequest)pJmxReq);
            }
        }

        private void workaroundForMXBeans(Set<MBeanServer> pMBeanServers, JmxObjectNameRequest pJmxReq) {
            JmxObjectNameRequest request = pJmxReq;
            if (request.getObjectName() != null && "java.lang".equals(request.getObjectName().getDomain())) {
                try {
                    this.fetchMBeanInfo(pMBeanServers, request.getObjectName());
                }
                catch (IntrospectionException e) {
                    throw new IllegalStateException("Workaround for JBoss failed for object " + request.getObjectName() + ": " + e);
                }
                catch (ReflectionException e) {
                    throw new IllegalStateException("Workaround for JBoss failed for object " + request.getObjectName() + ": " + e);
                }
            }
        }

        private void fetchMBeanInfo(Set<MBeanServer> pMBeanServers, ObjectName pObjectName) throws IntrospectionException, ReflectionException {
            for (MBeanServer s : pMBeanServers) {
                try {
                    s.getMBeanInfo(pObjectName);
                    return;
                }
                catch (InstanceNotFoundException exp) {
                }
            }
        }
    }
}

