/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;
import org.jolokia.request.JmxRequest;
import org.jolokia.util.ConfigKey;
import org.jolokia.util.LogHandler;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassfishDetector
extends AbstractServerDetector {
    private static final Pattern GLASSFISH_VERSION = Pattern.compile("^.*GlassFish.*\\sv?(.*?)$", 2);
    private static final Pattern GLASSFISH_FULL_VERSION = Pattern.compile("^.*GlassFish.*?\\sv?([.\\d]+).*$", 2);

    @Override
    public ServerHandle detect(Set<MBeanServer> pMbeanServers) {
        String version = this.detectVersion(pMbeanServers);
        if (version != null) {
            return new GlassfishServerHandle(version, null, new HashMap<String, String>());
        }
        return null;
    }

    private String detectVersion(Set<MBeanServer> pMbeanServers) {
        String fullVersion = this.getSingleStringAttribute(pMbeanServers, "com.sun.appserv:j2eeType=J2EEServer,*", "serverVersion");
        String version = this.extractVersionFromFullVersion(fullVersion);
        if (fullVersion == null || "3".equals(version)) {
            String versionFromAmx = this.getSingleStringAttribute(pMbeanServers, "amx:type=domain-root,*", "ApplicationServerFullVersion");
            version = this.getVersionFromFullVersion(version, versionFromAmx != null ? versionFromAmx : System.getProperty("glassfish.version"));
        } else if (this.mBeanExists(pMbeanServers, "com.sun.appserver:type=Host,*")) {
            version = "3";
        }
        return version;
    }

    private String extractVersionFromFullVersion(String pFullVersion) {
        Matcher matcher;
        if (pFullVersion != null && (matcher = GLASSFISH_VERSION.matcher(pFullVersion)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean isAmxBooted(Set<? extends MBeanServerConnection> pServers) {
        return this.mBeanExists(pServers, "amx:type=domain-root,*");
    }

    private void bootAmx(Set<? extends MBeanServerConnection> pServers, LogHandler pLoghandler) {
        ObjectName bootMBean = null;
        try {
            bootMBean = new ObjectName("amx-support:type=boot-amx");
        }
        catch (MalformedObjectNameException e) {
            // empty catch block
        }
        InstanceNotFoundException infExp = null;
        for (MBeanServerConnection mBeanServerConnection : pServers) {
            try {
                mBeanServerConnection.invoke(bootMBean, "bootAMX", null, null);
                return;
            }
            catch (InstanceNotFoundException e) {
                infExp = e;
            }
            catch (Exception e) {
                pLoghandler.error("Exception while executing bootAmx: " + e, e);
            }
        }
        if (infExp != null) {
            pLoghandler.error("No bootAmx MBean found: ", infExp);
        }
    }

    private String getVersionFromFullVersion(String pOriginalVersion, String pFullVersion) {
        if (pFullVersion == null) {
            return pOriginalVersion;
        }
        Matcher v3Matcher = GLASSFISH_FULL_VERSION.matcher(pFullVersion);
        if (v3Matcher.matches()) {
            return v3Matcher.group(1);
        }
        return pOriginalVersion;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GlassfishServerHandle
    extends ServerHandle {
        private boolean amxShouldBeBooted;
        private LogHandler logHandler;

        public GlassfishServerHandle(String version, URL agentUrl, Map<String, String> extraInfo) {
            super("Oracle", "glassfish", version, agentUrl, extraInfo);
            this.amxShouldBeBooted = false;
        }

        @Override
        public Map<String, String> getExtraInfo(Set<? extends MBeanServerConnection> pServers) {
            Map<String, String> extra = super.getExtraInfo(pServers);
            if (extra != null && this.getVersion().startsWith("3")) {
                extra.put("amxBooted", Boolean.toString(GlassfishDetector.this.isAmxBooted(pServers)));
            }
            return extra;
        }

        @Override
        public void preDispatch(Set<MBeanServer> pMBeanServers, JmxRequest pJmxReq) {
            if (this.amxShouldBeBooted) {
                GlassfishDetector.this.bootAmx(pMBeanServers, this.logHandler);
                this.amxShouldBeBooted = false;
            }
        }

        @Override
        public void postDetect(Set<? extends MBeanServerConnection> pServers, Map<ConfigKey, String> pConfig, LogHandler pLoghandler) {
            JSONObject opts = this.getDetectorOptions(pConfig, pLoghandler);
            this.amxShouldBeBooted = (opts == null || opts.get("bootAmx") == null || (Boolean)opts.get("bootAmx") != false) && !GlassfishDetector.this.isAmxBooted(pServers);
            this.logHandler = pLoghandler;
        }
    }
}

