/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.management.RuntimeMBeanException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jolokia.backend.BackendManager;
import org.jolokia.http.HttpRequestHandler;
import org.jolokia.restrictor.AllowAllRestrictor;
import org.jolokia.restrictor.DenyAllRestrictor;
import org.jolokia.restrictor.PolicyRestrictor;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.restrictor.RestrictorFactory;
import org.jolokia.util.ConfigKey;
import org.jolokia.util.LogHandler;
import org.json.simple.JSONAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentServlet
extends HttpServlet {
    private static final long serialVersionUID = 42L;
    private ServletRequestHandler httpGetHandler;
    private ServletRequestHandler httpPostHandler;
    private BackendManager backendManager;
    private LogHandler logHandler;
    private HttpRequestHandler requestHandler;
    private Restrictor restrictor;
    private String configMimeType;

    public AgentServlet() {
        this(null);
    }

    public AgentServlet(Restrictor pRestrictor) {
        this.restrictor = pRestrictor;
    }

    protected LogHandler getLogHandler() {
        return this.logHandler;
    }

    protected Restrictor createRestrictor(String pLocation) {
        LogHandler log = this.getLogHandler();
        try {
            PolicyRestrictor newRestrictor = RestrictorFactory.lookupPolicyRestrictor(pLocation);
            if (newRestrictor != null) {
                log.info("Using access restrictor " + pLocation);
                return newRestrictor;
            }
            log.info("No access restrictor found at " + pLocation + ", access to all MBeans is allowed");
            return new AllowAllRestrictor();
        }
        catch (IOException e) {
            log.error("Error while accessing access restrictor at " + pLocation + ". Denying all access to MBeans for security reasons. Exception: " + e, e);
            return new DenyAllRestrictor();
        }
    }

    @Override
    public void init(ServletConfig pServletConfig) throws ServletException {
        super.init(pServletConfig);
        this.logHandler = this.createLogHandler(pServletConfig);
        this.httpGetHandler = this.newGetHttpRequestHandler();
        this.httpPostHandler = this.newPostHttpRequestHandler();
        Map<ConfigKey, String> config = this.servletConfigAsMap(pServletConfig);
        if (this.restrictor == null) {
            this.restrictor = this.createRestrictor(ConfigKey.POLICY_LOCATION.getValue(config));
        } else {
            this.logHandler.info("Using custom access restriction provided by " + this.restrictor);
        }
        this.configMimeType = config.get((Object)ConfigKey.MIME_TYPE);
        if (this.configMimeType == null) {
            this.configMimeType = ConfigKey.MIME_TYPE.getDefaultValue();
        }
        this.backendManager = new BackendManager(config, this.logHandler, this.restrictor);
        this.requestHandler = new HttpRequestHandler(this.backendManager, this.logHandler);
    }

    protected LogHandler createLogHandler(ServletConfig pServletConfig) {
        return new LogHandler(){

            public void debug(String message) {
                AgentServlet.this.log(message);
            }

            public void info(String message) {
                AgentServlet.this.log(message);
            }

            public void error(String message, Throwable t) {
                AgentServlet.this.log(message, t);
            }
        };
    }

    @Override
    public void destroy() {
        this.backendManager.destroy();
        super.destroy();
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(this.httpGetHandler, req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(this.httpPostHandler, req, resp);
    }

    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, String> responseHeaders = this.requestHandler.handleCorsPreflightRequest(req.getHeader("Origin"), req.getHeader("Access-Control-Request-Headers"));
        for (Map.Entry<String, String> entry : responseHeaders.entrySet()) {
            resp.setHeader(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(ServletRequestHandler pReqHandler, HttpServletRequest pReq, HttpServletResponse pResp) throws IOException {
        JSONAware json = null;
        try {
            this.requestHandler.checkClientIPAccess(pReq.getRemoteHost(), pReq.getRemoteAddr());
            json = pReqHandler.handleRequest(pReq, pResp);
        }
        catch (Throwable exp) {
            json = this.requestHandler.handleThrowable(exp instanceof RuntimeMBeanException ? ((RuntimeMBeanException)exp).getTargetException() : exp);
        }
        finally {
            this.setCorsHeader(pReq, pResp);
            String callback = pReq.getParameter(ConfigKey.CALLBACK.getKeyValue());
            if (callback != null) {
                this.sendResponse(pResp, "text/javascript", callback + "(" + json.toJSONString() + ");");
            } else {
                this.sendResponse(pResp, this.getMimeType(pReq), json.toJSONString());
            }
        }
    }

    private void setCorsHeader(HttpServletRequest pReq, HttpServletResponse pResp) {
        String origin = this.requestHandler.extractCorsOrigin(pReq.getHeader("Origin"));
        if (origin != null) {
            pResp.setHeader("Access-Control-Allow-Origin", origin);
        }
    }

    private String getMimeType(HttpServletRequest pReq) {
        String requestMimeType = pReq.getParameter(ConfigKey.MIME_TYPE.getKeyValue());
        if (requestMimeType != null) {
            return requestMimeType;
        }
        return this.configMimeType;
    }

    private ServletRequestHandler newPostHttpRequestHandler() {
        return new ServletRequestHandler(){

            public JSONAware handleRequest(HttpServletRequest pReq, HttpServletResponse pResp) throws IOException {
                String encoding = pReq.getCharacterEncoding();
                ServletInputStream is = pReq.getInputStream();
                return AgentServlet.this.requestHandler.handlePostRequest(pReq.getRequestURI(), is, encoding, AgentServlet.this.getParameterMap(pReq));
            }
        };
    }

    private ServletRequestHandler newGetHttpRequestHandler() {
        return new ServletRequestHandler(){

            public JSONAware handleRequest(HttpServletRequest pReq, HttpServletResponse pResp) {
                return AgentServlet.this.requestHandler.handleGetRequest(pReq.getRequestURI(), pReq.getPathInfo(), AgentServlet.this.getParameterMap(pReq));
            }
        };
    }

    private Map<String, String[]> getParameterMap(HttpServletRequest pReq) {
        try {
            return pReq.getParameterMap();
        }
        catch (UnsupportedOperationException exp) {
            HashMap<String, String[]> ret = new HashMap<String, String[]>();
            Enumeration params = pReq.getParameterNames();
            while (params.hasMoreElements()) {
                String param = (String)params.nextElement();
                ret.put(param, pReq.getParameterValues(param));
            }
            return ret;
        }
    }

    private Map<ConfigKey, String> servletConfigAsMap(ServletConfig pConfig) {
        Enumeration e = pConfig.getInitParameterNames();
        HashMap<ConfigKey, String> ret = new HashMap<ConfigKey, String>();
        while (e.hasMoreElements()) {
            String keyS = (String)e.nextElement();
            ConfigKey key = ConfigKey.getGlobalConfigKey(keyS);
            if (key == null) continue;
            ret.put(key, pConfig.getInitParameter(keyS));
        }
        return ret;
    }

    private void sendResponse(HttpServletResponse pResp, String pContentType, String pJsonTxt) throws IOException {
        this.setContentType(pResp, pContentType);
        pResp.setStatus(200);
        this.setNoCacheHeaders(pResp);
        PrintWriter writer = pResp.getWriter();
        writer.write(pJsonTxt);
    }

    private void setNoCacheHeaders(HttpServletResponse pResp) {
        pResp.setHeader("Cache-Control", "no-cache");
        pResp.setHeader("Pragma", "no-cache");
        pResp.setHeader("Expires", "-1");
    }

    private void setContentType(HttpServletResponse pResp, String pContentType) {
        boolean encodingDone = false;
        try {
            pResp.setCharacterEncoding("utf-8");
            pResp.setContentType(pContentType);
            encodingDone = true;
        }
        catch (NoSuchMethodError error) {
        }
        catch (UnsupportedOperationException error) {
            // empty catch block
        }
        if (!encodingDone) {
            pResp.setContentType(pContentType + "; charset=utf-8");
        }
    }

    private static interface ServletRequestHandler {
        public JSONAware handleRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
    }
}

