/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.backend;

import java.util.UUID;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.jolokia.backend.MBeanServerHandler;
import org.jolokia.backend.RequestDispatcher;
import org.jolokia.converter.Converters;
import org.jolokia.detector.ServerHandle;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.handler.RequestHandlerManager;
import org.jolokia.history.HistoryStore;
import org.jolokia.mbean.Config;
import org.jolokia.request.JmxRequest;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.DebugStore;
import org.jolokia.util.LogHandler;

public class LocalRequestDispatcher
implements RequestDispatcher {
    private MBeanServerHandler mBeanServerHandler;
    private RequestHandlerManager requestHandlerManager;
    private String qualifier;
    private LogHandler log;

    public LocalRequestDispatcher(Converters pConverters, Restrictor pRestrictor, String pQualifier, LogHandler pLogHandler) {
        this.mBeanServerHandler = new MBeanServerHandler(pQualifier, pLogHandler);
        this.qualifier = pQualifier;
        this.log = pLogHandler;
        this.requestHandlerManager = new RequestHandlerManager(pConverters, this.mBeanServerHandler.getServerHandle(), pRestrictor);
    }

    public boolean canHandle(JmxRequest pJmxRequest) {
        return true;
    }

    public boolean useReturnValueWithPath(JmxRequest pJmxRequest) {
        JsonRequestHandler handler = this.requestHandlerManager.getRequestHandler(pJmxRequest.getType());
        return handler.useReturnValueWithPath();
    }

    public Object dispatchRequest(JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        JsonRequestHandler handler = this.requestHandlerManager.getRequestHandler(pJmxReq.getType());
        return this.mBeanServerHandler.dispatchRequest(handler, pJmxReq);
    }

    public void initMBeans(HistoryStore pHistoryStore, DebugStore pDebugStore) throws MalformedObjectNameException, MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        this.mBeanServerHandler.initMBean();
        String oName = this.createObjectNameWithQualifier("jolokia:type=Config");
        Config config = new Config(pHistoryStore, pDebugStore, oName);
        try {
            this.mBeanServerHandler.registerMBean(config, oName);
        }
        catch (InstanceAlreadyExistsException exp) {
            String alternativeOName = oName + ",uuid=" + UUID.randomUUID();
            this.log.info(oName + " is already registered. Adding it with " + alternativeOName + ", but you should revise your setup in " + "order to either use a qualifier or ensure, that only a single agent gets registered (otherwise history functionality might not work)");
            this.mBeanServerHandler.registerMBean(config, alternativeOName);
        }
        String legacyOName = this.createObjectNameWithQualifier("jmx4perl:type=Config");
        try {
            Config legacyConfig = new Config(pHistoryStore, pDebugStore, legacyOName);
            this.mBeanServerHandler.registerMBean(legacyConfig, legacyOName);
        }
        catch (InstanceAlreadyExistsException exp) {
            this.log.info("Cannot register (legacy) MBean handler for config store with name " + legacyOName + " since it already exists. " + "This is the case if another agent has been already started within the same JVM. The registration is skipped.");
        }
    }

    public void destroy() throws JMException {
        this.mBeanServerHandler.unregisterMBeans();
    }

    public ServerHandle getServerInfo() {
        return this.mBeanServerHandler.getServerHandle();
    }

    private String createObjectNameWithQualifier(String pOName) {
        return pOName + (this.qualifier != null ? "," + this.qualifier : "");
    }
}

