/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.mule;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.jolokia.http.AgentServlet;
import org.jolokia.mule.MuleAgentConfig;
import org.jolokia.util.NetworkUtil;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mule.api.agent.Agent;
import org.mule.api.lifecycle.StartException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.StopException;
import org.mule.api.lifecycle.Stoppable;

public class MuleAgentHttpServer {
    private Agent parent;
    private Server server;

    MuleAgentHttpServer(Agent pParent, MuleAgentConfig pConfig) {
        this.parent = pParent;
        this.server = this.getServer(pConfig);
        Context root = this.getContext((HandlerContainer)this.server, pConfig);
        ServletHolder servletHolder = this.getServletHolder(pConfig);
        root.addServlet(servletHolder, "/*");
    }

    public void start() throws StartException {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e, (Startable)this.parent);
        }
    }

    public void stop() throws StopException {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new StopException((Throwable)e, (Stoppable)this.parent);
        }
    }

    private Server getServer(MuleAgentConfig pConfig) {
        Server newServer = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        if (pConfig.getHost() != null) {
            connector.setHost(pConfig.getHost());
        }
        connector.setPort(pConfig.getPort());
        newServer.setConnectors(new Connector[]{connector});
        return newServer;
    }

    private ServletHolder getServletHolder(MuleAgentConfig pConfig) {
        ServletHolder holder = new ServletHolder((Servlet)new AgentServlet());
        holder.setInitParameters(this.getInitParameters(pConfig));
        holder.setInitOrder(1);
        return holder;
    }

    private Context getContext(HandlerContainer pContainer, MuleAgentConfig pConfig) {
        Context root = new Context(pContainer, "/jolokia", 1);
        if (pConfig.getUser() != null && pConfig.getPassword() != null) {
            root.setSecurityHandler(this.getSecurityHandler(pConfig.getUser(), pConfig.getPassword(), "jolokia-role"));
        }
        return root;
    }

    private SecurityHandler getSecurityHandler(String pUser, String pPassword, String pRole) {
        SecurityHandler securityHandler = new SecurityHandler();
        securityHandler.setConstraintMappings(this.getConstraintMappings(pRole));
        securityHandler.setUserRealm(this.getUserRealm(pUser, pPassword, pRole));
        return securityHandler;
    }

    private UserRealm getUserRealm(String pUser, String pPassword, String pRole) {
        HashUserRealm realm = new HashUserRealm("jolokia Realm");
        realm.put((Object)pUser, (Object)pPassword);
        realm.addUserToRole(pUser, pRole);
        return realm;
    }

    private ConstraintMapping[] getConstraintMappings(String ... pRoles) {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(pRoles);
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        return new ConstraintMapping[]{cm};
    }

    private Map getInitParameters(MuleAgentConfig pConfig) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("debugMaxEntries", "" + pConfig.getDebugMaxEntries());
        ret.put("historyMaxEntries", "" + pConfig.getHistoryMaxEntries());
        ret.put("maxCollectionsSize", "" + pConfig.getMaxCollectionSize());
        ret.put("maxDepth", "" + pConfig.getMaxDepth());
        ret.put("maxObjects", "" + pConfig.getMaxObjects());
        ret.put("debug", "" + pConfig.isDebug());
        ret.put("agentType", "mule");
        ret.put("agentId", NetworkUtil.getAgentId((int)this.hashCode(), (String)"mule"));
        return ret;
    }
}

