/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.util;

public interface LogHandler {
    public static final LogHandler QUIET = new LogHandler(){

        public void debug(String message) {
        }

        public void info(String message) {
        }

        public void error(String message, Throwable t) {
        }
    };

    public void debug(String var1);

    public void info(String var1);

    public void error(String var1, Throwable var2);

    public static class StdoutLogHandler
    implements LogHandler {
        private boolean doDebug;

        public StdoutLogHandler(boolean pDoDebug) {
            this.doDebug = pDoDebug;
        }

        public void debug(String message) {
            if (this.doDebug) {
                this.log("D> " + message);
            }
        }

        public void info(String message) {
            this.log("I> " + message);
        }

        public void error(String message, Throwable t) {
            this.log("E> " + message);
            t.printStackTrace();
        }

        private void log(String message) {
            System.out.println(message);
        }
    }
}

