/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.discovery;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jolokia.discovery.AgentDetailsHolder;
import org.jolokia.discovery.MulticastSocketListenerThread;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.LogHandler;
import org.jolokia.util.NetworkUtil;

public class DiscoveryMulticastResponder {
    private final AgentDetailsHolder detailsHolder;
    private final Restrictor restrictor;
    private final LogHandler logHandler;
    private InetAddress hostAddress;
    private List<MulticastSocketListenerThread> listenerThreads;

    public DiscoveryMulticastResponder(AgentDetailsHolder pDetailsHolder, Restrictor pRestrictor, LogHandler pLogHandler) throws UnknownHostException {
        this(null, pDetailsHolder, pRestrictor, pLogHandler);
    }

    public DiscoveryMulticastResponder(InetAddress pHostAddress, AgentDetailsHolder pDetailsHolder, Restrictor pRestrictor, LogHandler pLogHandler) {
        this.hostAddress = pHostAddress;
        this.detailsHolder = pDetailsHolder;
        this.restrictor = pRestrictor;
        this.logHandler = pLogHandler;
        this.listenerThreads = new ArrayList<MulticastSocketListenerThread>();
    }

    public synchronized void start() throws IOException {
        if (this.listenerThreads.size() == 0) {
            List<InetAddress> addresses;
            List<InetAddress> list = addresses = this.hostAddress == null ? NetworkUtil.getMulticastAddresses() : Arrays.asList(this.hostAddress);
            if (addresses.size() == 0) {
                this.logHandler.info("No suitable address found for listening on multicast discovery requests");
                return;
            }
            for (InetAddress addr : addresses) {
                MulticastSocketListenerThread thread = new MulticastSocketListenerThread(addr, this.detailsHolder, this.restrictor, this.logHandler);
                thread.start();
                this.listenerThreads.add(thread);
            }
        }
    }

    public synchronized void stop() {
        if (this.listenerThreads.size() > 0) {
            for (MulticastSocketListenerThread thread : this.listenerThreads) {
                thread.shutdown();
            }
        }
        this.listenerThreads.clear();
    }
}

