/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.request;

import java.util.List;
import java.util.Map;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.ProcessingParameters;
import org.jolokia.converter.json.ValueFaultHandler;
import org.jolokia.request.ProxyTargetConfig;
import org.jolokia.util.EscapeUtil;
import org.jolokia.util.HttpMethod;
import org.jolokia.util.RequestType;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JmxRequest {
    private RequestType type;
    private ProxyTargetConfig targetConfig = null;
    private ProcessingParameters processingConfig;
    private ValueFaultHandler valueFaultHandler;
    private HttpMethod method;
    private List<String> pathParts;

    protected JmxRequest(RequestType pType, List<String> pPathParts, ProcessingParameters pProcessingParams) {
        this(pType, HttpMethod.GET, pPathParts, pProcessingParams);
    }

    public JmxRequest(Map<String, ?> pMap, ProcessingParameters pInitParams) {
        this(RequestType.getTypeByName((String)pMap.get("type")), HttpMethod.POST, EscapeUtil.parsePath((String)pMap.get("path")), pInitParams);
        Map target = (Map)pMap.get("target");
        if (target != null) {
            this.targetConfig = new ProxyTargetConfig(target);
        }
    }

    private JmxRequest(RequestType pType, HttpMethod pMethod, List<String> pPathParts, ProcessingParameters pProcessingParams) {
        this.method = pMethod;
        this.type = pType;
        this.pathParts = pPathParts;
        this.initParameters(pProcessingParams);
    }

    public RequestType getType() {
        return this.type;
    }

    public String getParameter(ConfigKey pConfigKey) {
        return this.processingConfig.get(pConfigKey);
    }

    public int getParameterAsInt(ConfigKey pConfigKey) {
        String intValueS = this.processingConfig.get(pConfigKey);
        if (intValueS != null) {
            return Integer.parseInt(intValueS);
        }
        return 0;
    }

    public Boolean getParameterAsBool(ConfigKey pConfigKey) {
        String booleanS = this.getParameter(pConfigKey);
        return Boolean.parseBoolean(booleanS != null ? booleanS : pConfigKey.getDefaultValue());
    }

    public ProxyTargetConfig getTargetConfig() {
        return this.targetConfig;
    }

    public HttpMethod getHttpMethod() {
        return this.method;
    }

    public ValueFaultHandler getValueFaultHandler() {
        return this.valueFaultHandler;
    }

    protected String getInfo() {
        StringBuffer ret = new StringBuffer();
        if (this.pathParts != null) {
            ret.append(", path=").append(this.pathParts);
        }
        if (this.targetConfig != null) {
            ret.append(", target=").append(this.targetConfig);
        }
        return ret.length() > 0 ? ret.toString() : null;
    }

    public List<String> getPathParts() {
        return this.pathParts;
    }

    public String getPath() {
        return EscapeUtil.combineToPath(this.pathParts);
    }

    public JSONObject toJSON() {
        JSONObject ret = new JSONObject();
        ret.put((Object)"type", (Object)this.type.getName());
        if (this.targetConfig != null) {
            ret.put((Object)"target", (Object)this.targetConfig.toJSON());
        }
        if (this.pathParts != null) {
            try {
                ret.put((Object)"path", (Object)this.getPath());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return ret;
    }

    private void initParameters(ProcessingParameters pParams) {
        this.processingConfig = pParams;
        String ignoreErrors = this.processingConfig.get(ConfigKey.IGNORE_ERRORS);
        this.valueFaultHandler = ignoreErrors != null && ignoreErrors.matches("^(true|yes|on|1)$") ? ValueFaultHandler.IGNORING_VALUE_FAULT_HANDLER : ValueFaultHandler.THROWING_VALUE_FAULT_HANDLER;
    }
}

