/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.request;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jolokia.request.ProxyTargetConfig;
import org.jolokia.request.ValueFaultHandler;
import org.jolokia.util.ConfigKey;
import org.jolokia.util.EscapeUtil;
import org.jolokia.util.HttpMethod;
import org.jolokia.util.RequestType;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JmxRequest {
    private RequestType type;
    private ProxyTargetConfig targetConfig = null;
    private Map<ConfigKey, String> processingConfig = new HashMap<ConfigKey, String>();
    private ValueFaultHandler valueFaultHandler;
    private HttpMethod method;
    private List<String> pathParts;
    public static final ValueFaultHandler IGNORING_VALUE_FAULT_HANDLER = new ValueFaultHandler(){

        @Override
        public <T extends Throwable> Object handleException(T exception) throws T {
            return "ERROR: " + exception.getMessage() + " (" + exception.getClass() + ")";
        }
    };
    public static final ValueFaultHandler THROWING_VALUE_FAULT_HANDLER = new ValueFaultHandler(){

        @Override
        public <T extends Throwable> Object handleException(T exception) throws T {
            throw exception;
        }
    };

    protected JmxRequest(RequestType pType, List<String> pPathParts, Map<String, String> pInitParams) {
        this(pType, HttpMethod.GET, pPathParts, pInitParams);
    }

    public JmxRequest(Map<String, ?> pMap, Map<String, String> pInitParams) {
        this(RequestType.getTypeByName((String)pMap.get("type")), HttpMethod.POST, EscapeUtil.parsePath((String)pMap.get("path")), pInitParams);
        Map target = (Map)pMap.get("target");
        if (target != null) {
            this.targetConfig = new ProxyTargetConfig(target);
        }
    }

    private JmxRequest(RequestType pType, HttpMethod pMethod, List<String> pPathParts, Map<String, String> pInitParams) {
        this.method = pMethod;
        this.type = pType;
        this.pathParts = pPathParts;
        this.initParameters(pInitParams);
    }

    public RequestType getType() {
        return this.type;
    }

    public String getProcessingConfig(ConfigKey pConfigKey) {
        return this.processingConfig.get((Object)pConfigKey);
    }

    public Integer getProcessingConfigAsInt(ConfigKey pConfigKey) {
        String intValueS = this.processingConfig.get((Object)pConfigKey);
        if (intValueS != null) {
            return Integer.parseInt(intValueS);
        }
        return null;
    }

    public ProxyTargetConfig getTargetConfig() {
        return this.targetConfig;
    }

    public HttpMethod getHttpMethod() {
        return this.method;
    }

    public ValueFaultHandler getValueFaultHandler() {
        return this.valueFaultHandler;
    }

    protected String getInfo() {
        StringBuffer ret = new StringBuffer();
        if (this.pathParts != null) {
            ret.append(", path=").append(this.pathParts);
        }
        if (this.targetConfig != null) {
            ret.append(", target=").append(this.targetConfig);
        }
        return ret.length() > 0 ? ret.toString() : null;
    }

    public List<String> getPathParts() {
        return this.pathParts;
    }

    public String getPath() {
        return EscapeUtil.combineToPath(this.pathParts);
    }

    public JSONObject toJSON() {
        JSONObject ret = new JSONObject();
        ret.put((Object)"type", (Object)this.type.getName());
        if (this.targetConfig != null) {
            ret.put((Object)"target", (Object)this.targetConfig.toJSON());
        }
        if (this.pathParts != null) {
            try {
                ret.put((Object)"path", (Object)this.getPath());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return ret;
    }

    private void initParameters(Map<String, String> pParams) {
        String ignoreErrors;
        if (pParams != null) {
            for (Map.Entry<String, String> entry : pParams.entrySet()) {
                ConfigKey cKey = ConfigKey.getRequestConfigKey(entry.getKey());
                String value = entry.getValue();
                if (cKey == null) continue;
                this.processingConfig.put(cKey, value != null ? value.toString() : null);
            }
        }
        this.valueFaultHandler = (ignoreErrors = this.processingConfig.get((Object)ConfigKey.IGNORE_ERRORS)) != null && ignoreErrors.matches("^(true|yes|on|1)$") ? IGNORING_VALUE_FAULT_HANDLER : THROWING_VALUE_FAULT_HANDLER;
    }
}

