/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.mbean;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.history.HistoryKey;
import org.jolokia.history.HistoryStore;
import org.jolokia.mbean.ConfigMBean;
import org.jolokia.util.DebugStore;

public class Config
implements ConfigMBean,
MBeanRegistration {
    private HistoryStore historyStore;
    private DebugStore debugStore;
    private String objectName;

    public Config(HistoryStore pHistoryStore, DebugStore pDebugStore, String pOName) {
        this.historyStore = pHistoryStore;
        this.debugStore = pDebugStore;
        this.objectName = pOName;
    }

    public void setHistoryEntriesForAttribute(String pMBean, String pAttribute, String pPath, String pTarget, int pMaxEntries) throws MalformedObjectNameException {
        HistoryKey key = new HistoryKey(pMBean, pAttribute, pPath, pTarget);
        this.historyStore.configure(key, pMaxEntries);
    }

    public void setHistoryEntriesForOperation(String pMBean, String pOperation, String pTarget, int pMaxEntries) throws MalformedObjectNameException {
        HistoryKey key = new HistoryKey(pMBean, pOperation, pTarget);
        this.historyStore.configure(key, pMaxEntries);
    }

    public void resetHistoryEntries() {
        this.historyStore.reset();
    }

    public String debugInfo() {
        return this.debugStore.debugInfo();
    }

    public void resetDebugInfo() {
        this.debugStore.resetDebugInfo();
    }

    public int getHistoryMaxEntries() {
        return this.historyStore.getGlobalMaxEntries();
    }

    public void setHistoryMaxEntries(int pLimit) {
        this.historyStore.setGlobalMaxEntries(pLimit);
    }

    public boolean isDebug() {
        return this.debugStore.isDebug();
    }

    public void setDebug(boolean pSwitch) {
        this.debugStore.setDebug(pSwitch);
    }

    public int getMaxDebugEntries() {
        return this.debugStore.getMaxDebugEntries();
    }

    public void setMaxDebugEntries(int pNumber) {
        this.debugStore.setMaxDebugEntries(pNumber);
    }

    public int getHistorySize() {
        return this.historyStore.getSize();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return new ObjectName(this.objectName);
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() {
    }

    public void postDeregister() {
    }
}

