/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.ArrayExtractor;
import org.jolokia.converter.json.BeanExtractor;
import org.jolokia.converter.json.CompositeDataExtractor;
import org.jolokia.converter.json.DateExtractor;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ListExtractor;
import org.jolokia.converter.json.MapExtractor;
import org.jolokia.converter.json.ObjectSerializationContext;
import org.jolokia.converter.json.TabularDataExtractor;
import org.jolokia.converter.object.StringToObjectConverter;
import org.jolokia.request.JmxRequest;
import org.jolokia.request.ValueFaultHandler;
import org.jolokia.util.ConfigKey;
import org.jolokia.util.EscapeUtil;
import org.jolokia.util.ServiceObjectFactory;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectToJsonConverter {
    private List<Extractor> handlers;
    private ArrayExtractor arrayExtractor;
    private ThreadLocal<ObjectSerializationContext> stackContextLocal = new ThreadLocal();
    private StringToObjectConverter stringToObjectConverter;
    private Integer hardMaxDepth;
    private Integer hardMaxCollectionSize;
    private Integer hardMaxObjects;
    private static final String SIMPLIFIERS_DEFAULT_DEF = "META-INF/simplifiers-default";
    private static final String SIMPLIFIERS_DEF = "META-INF/simplifiers";

    public ObjectToJsonConverter(StringToObjectConverter pStringToObjectConverter, Map<ConfigKey, String> pConfig, Extractor ... pSimplifyHandlers) {
        this.initLimits(pConfig);
        this.handlers = new ArrayList<Extractor>();
        this.handlers.add(new TabularDataExtractor());
        this.handlers.add(new CompositeDataExtractor());
        this.handlers.add(new ListExtractor());
        this.handlers.add(new MapExtractor());
        this.addSimplifiers(this.handlers, pSimplifyHandlers);
        this.handlers.add(new DateExtractor());
        this.handlers.add(new BeanExtractor());
        this.arrayExtractor = new ArrayExtractor();
        this.stringToObjectConverter = pStringToObjectConverter;
    }

    public JSONObject convertToJson(Object pValue, JmxRequest pRequest, boolean pUseValueWithPath) throws AttributeNotFoundException {
        Stack<String> extraStack = pUseValueWithPath ? EscapeUtil.reversePath(pRequest.getPathParts()) : new Stack<String>();
        Object jsonResult = this.extractObjectWithContext(pRequest, pValue, extraStack, true);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"value", jsonResult);
        jsonObject.put((Object)"request", (Object)pRequest.toJSON());
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractObjectWithContext(JmxRequest pRequest, Object pValue, Stack<String> pExtraArgs, boolean pJsonify) throws AttributeNotFoundException {
        Object jsonResult;
        this.setupContext(pRequest);
        try {
            jsonResult = this.extractObject(pValue, pExtraArgs, pJsonify);
        }
        finally {
            this.clearContext();
        }
        return jsonResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractObject(Object pValue, Stack<String> pExtraArgs, boolean pJsonify) throws AttributeNotFoundException {
        Stack<String> pathStack;
        ObjectSerializationContext stackContext = this.stackContextLocal.get();
        String limitReached = this.checkForLimits(pValue, stackContext);
        Stack<String> stack = pathStack = pExtraArgs != null ? pExtraArgs : new Stack<String>();
        if (limitReached != null) {
            return limitReached;
        }
        try {
            stackContext.push(pValue);
            if (pValue == null) {
                Object var7_7 = null;
                return var7_7;
            }
            if (pValue.getClass().isArray()) {
                Object object = this.arrayExtractor.extractObject(this, pValue, pathStack, pJsonify);
                return object;
            }
            Object object = this.callHandler(pValue, pathStack, pJsonify);
            return object;
        }
        finally {
            stackContext.pop();
        }
    }

    public Object setObjectValue(Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        Class<?> clazz = pInner.getClass();
        if (clazz.isArray()) {
            return this.arrayExtractor.setObjectValue(this.stringToObjectConverter, pInner, pAttribute, pValue);
        }
        Extractor handler = this.getExtractor(clazz);
        if (handler != null) {
            return handler.setObjectValue(this.stringToObjectConverter, pInner, pAttribute, pValue);
        }
        throw new IllegalStateException("Internal error: No handler found for class " + clazz + " for setting object value." + " (object: " + pInner + ", attribute: " + pAttribute + ", value: " + pValue + ")");
    }

    int getCollectionLength(int originalLength) {
        ObjectSerializationContext ctx = this.stackContextLocal.get();
        Integer maxSize = ctx.getMaxCollectionSize();
        if (maxSize != null && originalLength > maxSize) {
            return maxSize;
        }
        return originalLength;
    }

    public ValueFaultHandler getValueFaultHandler() {
        ObjectSerializationContext ctx = this.stackContextLocal.get();
        return ctx.getValueFaultHandler();
    }

    void clearContext() {
        this.stackContextLocal.remove();
    }

    void setupContext() {
        this.setupContext(null);
    }

    void setupContext(JmxRequest pRequest) {
        if (pRequest != null) {
            Integer maxDepth = this.getLimit(pRequest.getProcessingConfigAsInt(ConfigKey.MAX_DEPTH), this.hardMaxDepth);
            Integer maxCollectionSize = this.getLimit(pRequest.getProcessingConfigAsInt(ConfigKey.MAX_COLLECTION_SIZE), this.hardMaxCollectionSize);
            Integer maxObjects = this.getLimit(pRequest.getProcessingConfigAsInt(ConfigKey.MAX_OBJECTS), this.hardMaxObjects);
            this.setupContext(maxDepth, maxCollectionSize, maxObjects, pRequest.getValueFaultHandler());
        } else {
            this.setupContext(this.hardMaxDepth, this.hardMaxCollectionSize, this.hardMaxObjects, JmxRequest.THROWING_VALUE_FAULT_HANDLER);
        }
    }

    void setupContext(Integer pMaxDepth, Integer pMaxCollectionSize, Integer pMaxObjects, ValueFaultHandler pValueFaultHandler) {
        ObjectSerializationContext stackContext = new ObjectSerializationContext(pMaxDepth, pMaxCollectionSize, pMaxObjects, pValueFaultHandler);
        this.stackContextLocal.set(stackContext);
    }

    private Extractor getExtractor(Class pClazz) {
        for (Extractor handler : this.handlers) {
            if (!handler.canSetValue() || handler.getType() == null || !handler.getType().isAssignableFrom(pClazz)) continue;
            return handler;
        }
        return null;
    }

    private void initLimits(Map<ConfigKey, String> pConfig) {
        if (pConfig != null) {
            this.hardMaxDepth = this.getNullSaveIntLimit(ConfigKey.MAX_DEPTH.getValue(pConfig));
            this.hardMaxCollectionSize = this.getNullSaveIntLimit(ConfigKey.MAX_COLLECTION_SIZE.getValue(pConfig));
            this.hardMaxObjects = this.getNullSaveIntLimit(ConfigKey.MAX_OBJECTS.getValue(pConfig));
        } else {
            this.hardMaxDepth = this.getNullSaveIntLimit(ConfigKey.MAX_DEPTH.getDefaultValue());
            this.hardMaxCollectionSize = this.getNullSaveIntLimit(ConfigKey.MAX_COLLECTION_SIZE.getDefaultValue());
            this.hardMaxObjects = this.getNullSaveIntLimit(ConfigKey.MAX_OBJECTS.getDefaultValue());
        }
    }

    private Integer getNullSaveIntLimit(String pValue) {
        Integer ret = pValue != null ? Integer.valueOf(Integer.parseInt(pValue)) : null;
        return ret != null && ret == 0 ? null : ret;
    }

    private String checkForLimits(Object pValue, ObjectSerializationContext pStackContext) {
        if (pStackContext.exceededMaxDepth()) {
            return pValue.toString();
        }
        if (pValue != null && pStackContext.alreadyVisited(pValue)) {
            return "[Reference " + pValue.getClass().getName() + "@" + Integer.toHexString(pValue.hashCode()) + "]";
        }
        if (pStackContext.exceededMaxObjects()) {
            return "[Object limit exceeded]";
        }
        return null;
    }

    private Object callHandler(Object pValue, Stack<String> pExtraArgs, boolean pJsonify) throws AttributeNotFoundException {
        Class<?> pClazz = pValue.getClass();
        for (Extractor handler : this.handlers) {
            if (handler.getType() == null || !handler.getType().isAssignableFrom(pClazz)) continue;
            return handler.extractObject(this, pValue, pExtraArgs, pJsonify);
        }
        throw new IllegalStateException("Internal error: No handler found for class " + pClazz + " (object: " + pValue + ", extraArgs: " + pExtraArgs + ")");
    }

    ThreadLocal<ObjectSerializationContext> getStackContextLocal() {
        return this.stackContextLocal;
    }

    private Integer getLimit(Integer pReqValue, Integer pHardLimit) {
        if (pReqValue == null) {
            return pHardLimit;
        }
        if (pHardLimit != null) {
            return pReqValue > pHardLimit ? pHardLimit : pReqValue;
        }
        return pReqValue;
    }

    private void addSimplifiers(List<Extractor> pHandlers, Extractor[] pSimplifyHandlers) {
        if (pSimplifyHandlers != null && pSimplifyHandlers.length > 0) {
            pHandlers.addAll(Arrays.asList(pSimplifyHandlers));
        } else {
            pHandlers.addAll(ServiceObjectFactory.createServiceObjects(SIMPLIFIERS_DEFAULT_DEF, SIMPLIFIERS_DEF));
        }
    }
}

